import logging
import os
from sandbox import sdk2
from sandbox.projects.common.teamcity import TeamcityArtifacts, TeamcityServiceMessagesLog

_logger = logging.getLogger('resources')


class TeamcitySandboxRunnerInternalArtifacts(sdk2.Resource):
    """
    resource with reused files in TEAMCITY_RUNNER_STAGE
    """
    ttl = 1


class TeamcitySandboxRunnerCache(sdk2.Resource):
    """
    resource with TSR caches
    """
    target = sdk2.parameters.String('Target', default='unknown')
    version = sdk2.parameters.String('Version', default='unknown')
    cache_owner = sdk2.parameters.String('Owner', default='unknown')
    config_hash = sdk2.parameters.String('Config\'s hash', default='')
    platform = sdk2.parameters.String('Platform')
    releasable = True
    shared_common_name = sdk2.parameters.String('Shared cache name', default='')
    auto_backup = True
    releasers = ['aslevushkin', 'thevery']
    ttl = 7


def create_teamcity_artifacts_resource(task):
    _logger.info('Creating TeamcityArtifacts resource.')
    teamcity_artifacts_path = 'teamcity_artifacts'
    if not os.path.exists(teamcity_artifacts_path):
        os.makedirs(teamcity_artifacts_path)
    _logger.info('TeamcityArtifacts resource.')
    return TeamcityArtifacts(task, 'TeamCity artifacts', teamcity_artifacts_path, auto_backup=True).id


def create_teamcity_messages_resource(task):
    _logger.info('Creating TeamcityServiceMessagesLog resource.')
    teamcity_messages_path = str(task.path("teamcity_messages.log"))
    with open(teamcity_messages_path, 'w'):
        pass
    _logger.info('TeamcityServiceMessagesLog resource.')
    return TeamcityServiceMessagesLog(task, 'TeamCity messages', teamcity_messages_path, auto_backup=True).id
