from sandbox.sandboxsdk.environments import TarballToolkitBase


class JdkEnvironment(TarballToolkitBase):
    """ Sandbox environment to work with JDK. """

    resource_type = 'JAVA_JDK_ENVIRONMENT'
    name = 'jdk'
    sys_path_utils = []
    STABLE = '13.0.1'

    def __init__(self, version=None, **kws):
        super(JdkEnvironment, self).__init__(version or JdkEnvironment.STABLE, 'darwin', **kws)

    def prepare(self):
        env_dir = super(JdkEnvironment, self).prepare()
        self.update_os_env('JAVA_HOME', env_dir)
        return env_dir
