import os
import logging
import tempfile
import shutil
from sandbox.sdk2.helpers import subprocess

from sandbox.common.errors import ResourceNotFound
from sandbox import sdk2
from sandbox.projects.mobile_apps.utils.resources import ProvisionProfile

logger = logging.getLogger(__name__)


class ProvisionProfileEnvironment(object):

    def get_resource(self):
        self.resource = ProvisionProfile.find(state='READY').first()
        if not self.resource:
            raise ResourceNotFound("Could not find any ProvisionProfile resource")
        logger.info("Using ProvisionProfile resource %s with BitBucket hash commit %s created by %s",
                    self.resource.id,
                    self.resource.hash,
                    self.resource.task_id
                    )

    def _execute_cmd(self, cmd):
        logger.debug("Executing the command {}.".format(cmd))
        result = subprocess.call(cmd)
        logger.debug('Executed result: {}'.format(result))

    def extract_profiles(self):
        data = sdk2.ResourceData(self.resource)
        source_dir = tempfile.mkdtemp()
        cmd = ["tar", "-C", source_dir, "-xf", str(data.path)]
        self._execute_cmd(cmd)

        target_folder = os.path.expanduser("~/Library/MobileDevice/Provisioning Profiles")
        shutil.copytree(os.path.join(source_dir, 'Provisioning_Profiles'),
                        target_folder)

        logger.info('Profiles extracted')

    def prepare(self):
        self.get_resource()
        self.extract_profiles()
