from sandbox import sdk2


class RvmPlusRuby(sdk2.Resource):
    """
        Tarball with installed RVM + Ruby
    """
    version = sdk2.Attributes.String('rvm+ruby version', required=True)
    platform = sdk2.parameters.String('Platform')
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['r2d2', 'thevery']


class ProvisionProfile(sdk2.Resource):
    """
        Tarball with profiles from ssh://git@bitbucket.browser.yandex-team.ru/mt/mobile-ios-provisioning-profiles.git'
    """
    pack_tar = 1
    ttl = "inf"
    auto_backup = True


class AndroidSdk(sdk2.Resource):
    """
        Tarball with installed Android SDK
    """
    version = sdk2.Attributes.String('android sdk version', required=True)
    platform = sdk2.parameters.String('Platform')
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['r2d2', 'thevery']
    android_platform_versions = sdk2.Attributes.String('android platform versions')
    build_tools = sdk2.Attributes.String('build-tools versions')
    ndk = sdk2.Attributes.String
    system_images = sdk2.Attributes.String
    packages = sdk2.Attributes.String


class GenericResource(sdk2.Resource):
    """
        Tarball with resource built by GenericResourceBuilder
    """
    pack_tar = True
    auto_backup = True
    releasable = True
    any_arch = False
    ttl = "inf"

    platform = sdk2.parameters.String('Platform')
    resource_version = sdk2.Attributes.String('Resource version', required=True)
    resource_name = sdk2.Attributes.String('Resource name', required=True)


class XcodeArchive(sdk2.Resource):
    """
        Resource with Xcode
    """
    version = sdk2.parameters.String('Xcode version', default='unknown')
    platform = sdk2.parameters.String('Platform')
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['thevery', 'r2d2']


class XcodeSimulatorArchive(sdk2.Resource):
    """
        Tarball with Xcode Simulator (iOS, tvOS, watchOS)
    """
    version = sdk2.parameters.String('Xcode Simulator version', default='unknown',
                                     description='Example: "iOS 15.0", "tvOS 14.5"')
    platform = sdk2.parameters.String('Platform')
    releasable = True
    any_arch = False
    auto_backup = True
    pack_tar = 1  # pack to tar
    releasers = ['thevery', 'r2d2']
