import os
import logging
import subprocess

from sandbox.sandboxsdk.environments import SandboxEnvironment
from sandbox.projects.mobile_apps.utils.resources import RvmPlusRuby

_logger = logging.getLogger(__name__)


class RvmPlusRubyEnvironment(SandboxEnvironment):
    """
        Sandbox environment to work smoothly with RVM + Ruby, originally created by mobvteam
        RVM: Ruby environment Manager
        https://rvm.io/
    """
    resource_type = RvmPlusRuby

    name = 'rvm_plus_ruby'

    sys_path_utils = ['rvm', ]

    STABLE = '1.29.10+2.6.5'

    USER_RVM_DIR = '~/.rvm'
    RVM_DIRNAME = '.rvm'

    def __init__(self, version=None, platform=None, **kws):
        super(RvmPlusRubyEnvironment, self).__init__(version or RvmPlusRubyEnvironment.STABLE,
                                                     platform or 'macos_x86',
                                                     **kws)

    def _printenv(self, with_rvm=False):
        cmd = 'printenv' if not with_rvm else 'bash -lc "source {} && printenv"'.format(os.path.join(self.USER_RVM_DIR, 'scripts/rvm'))
        env = [l.split('=', 1) for l in subprocess.check_output(cmd, shell=True).decode('utf-8').replace(',', '\n').splitlines()]
        return dict([pair for pair in env if len(pair) == 2])

    def _update_env(self):
        old_env = self._printenv()
        _logger.debug("old_env {}".format(old_env))
        actual_env = self._printenv(with_rvm=True)
        _logger.debug("actual_env {}".format(actual_env))
        new_env = {key: value for key, value in actual_env.items() if key not in old_env or old_env[key] != value}
        for key, value in new_env.items():
            self.update_os_env(key, value)
        _logger.debug("self.os_env {}".format(self.os_env))

    def prepare(self):
        resource_path = self.get_environment_resource()
        self.extract_tar(resource_path, os.path.expanduser('~'))
        self._update_env()
        self.check_environment()
        return os.path.expanduser(self.USER_RVM_DIR)
