import logging

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.sandboxsdk.environments import Xcode

from sandbox.projects.common import binary_task

_logger = logging.getLogger(__name__)


class XcodeCleanerParameters(sdk2.Task.Parameters):
    ext_params = binary_task.binary_release_parameters(stable=True)

    with sdk2.parameters.Group('xcode cleaner parameters'):
        xcode_versions = sdk2.parameters.String(
            'xcode versions',
            default='11.3.1',
            description='Enter xcode version to setup. All other versions will be cleaned')


class XcodeCleaner(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(XcodeCleanerParameters):
        pass

    @property
    def binary_executor_query(self):
        return {
            "attrs": {"task_type": "XCODE_CLEANER",
                      "released": self.Parameters.binary_executor_release_type,
                      "target": "xcode_cleaner/bin(osx)"},
            "state": [ctr.State.READY],
            "owner": "MOBDEVTOOLS"
        }

    def on_execute(self):
        sdk2.Task.current.agentr.prepare_host_for_multixcode()
        for xcode_version in self.Parameters.xcode_versions.split(';'):
            Xcode.prepare_xcode(xcode_version)
