# -*- coding: utf-8 -*-
import os

import sandbox.common.types.misc as ctm
from sandbox.projects.metrika.utils.vcs import checkout
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin

from sandbox import sdk2
from sandbox.projects.metrika.utils.parameters import VcsParameters, LastPeasantContainerResource


class MobileadsCountBugWeightJob(sdk2.Task, BaseConsoleMixin):
    WORKING_DIR = 'wd'

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        container = LastPeasantContainerResource("Environment container resource", required=True)
        kill_timeout = 36000
        vcs_block = VcsParameters()

        vault_owner = sdk2.parameters.String("Private key vault onwer",
                                             description="Имя группы/пользователя, владельца секрета, "
                                                         "в котором хранится приватный ключ",
                                             required=True,
                                             default="YANDEX_MOBILEADS_SDK")

        private_key_vault_name = sdk2.parameters.String("Private key vault name",
                                                        description="Имя секрета, "
                                                                    "в котором хранится приватный ssh ключ",
                                                        required=True)

        startreck_token_vault_name = sdk2.parameters.String("Startreck token vault name",
                                                            description="Имя секрета, "
                                                                        "в котором хранится startreck-token",
                                                            required=True)

        issue_id = sdk2.parameters.String("Issue id for weight count",
                                          description="ID задачи для подсчета веса",
                                          required=True)

        script = sdk2.parameters.String("Script to run", required=True)

    def on_execute(self):
        with sdk2.ssh.Key(self, self.Parameters.vault_owner, self.Parameters.private_key_vault_name):
            with sdk2.helpers.ProgressMeter("Checkout"):
                self._checkout_branch()
            with sdk2.helpers.ProgressMeter("Run script"):
                env = os.environ.copy()

                env['STARTREK_TOKEN'] = sdk2.Vault.data(self.Parameters.vault_owner,
                                                        self.Parameters.startreck_token_vault_name)

                arguments = ['--issue_id', self.Parameters.issue_id]
                cmd = ['python']
                if self.Parameters.script.endswith('.py'):
                    cmd.append(os.path.join(self._work_dir(), self.Parameters.script))
                else:
                    cmd.extend(['-m', self.Parameters.script])
                self._execute_shell_and_check(
                    cmd + arguments,
                    cwd=self._work_dir(),
                    env=env,
                    verbose=False
                )

    def _checkout_branch(self):
        checkout(self.Parameters.vcs_block, self._work_dir())

    def _work_dir(self, *path):
        return str(self.path(self.WORKING_DIR, *path))
