# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertAbuseDailyAggregator(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-705: Aggregate daily abuses, join user identifiers and group by user abuse count.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with daily_aggregator binary',
                resource_type=[resource_types.MODADVERT_ABUSE_DAILY_AGGREGATOR],
                required=True
            )

        with sdk2.parameters.Group('Input options') as options_group:
            banners_direct = sdk2.parameters.String(
                'Direct table with banners bids and uids',
                default='//home/direct/db/banners'
            )
            yandexuids = sdk2.parameters.String(
                'Table with uids, yandexuids and client_ids',
                default='//home/modadvert/test/biryuk/crypta/users_log'
            )
            supermoderation_url = sdk2.parameters.String(
                'Supermoderation API URL',
                default='http://localhost:8080'
            )
            state = sdk2.parameters.String(
                'YT file containing list of produced tables',
                default='//home/modadvert/test/vlad-mois/MODADVERT-705/state/processed'
            )
            directory_src = sdk2.parameters.String(
                'Directory path with preagreggated tables',
                default='//home/modadvert/test/antilost/abuse/preaggregated_bs_abuse_log'
            )
            no_input_failure_interval_hours = sdk2.parameters.Integer(
                'Exit without exception if last processed table was not older in hours than',
                default=24
            )
        with sdk2.parameters.Group('Output options') as options_group:
            directory_dst = sdk2.parameters.String(
                'Destination directory to put results table',
                default='//home/modadvert/test/vlad-mois/MODADVERT-705'
            )
            output_format = sdk2.parameters.String(
                'Destination table name format',
                default='ModAbuseBanners%Y%m%d'
            )
        with sdk2.parameters.Group('Perfomance details') as options_group:
            chunk_size = sdk2.parameters.Integer('Get object API usage chunk size', default=1000)
            save_big_intermediate = sdk2.parameters.Bool('Save big intermediate tables until they are changed', default=True)
            big_intermediate_dir = sdk2.parameters.String(
                'Directory to save big intermediate tables',
                default='//home/modadvert/test/vlad-mois/MODADVERT-705/big-intermediate'
            )
            max_tables_count_to_keep_in_state = sdk2.parameters.Integer('Max tables to keep in state', default=120)
        with sdk2.parameters.Group('Debug options') as options_group:
            save_debug = sdk2.parameters.Bool('Save intermediate tables for debug purposes', default=False)
            debug_dir = sdk2.parameters.String(
                'Directory to save intermediate debug tables',
                default='//home/modadvert/test/vlad-mois/MODADVERT-705/debug'
            )

    def on_before_execute(self):
        super(ModadvertAbuseDailyAggregator, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './daily_aggregator',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--chunk-size', self.Parameters.chunk_size,
            '--banners-direct', self.Parameters.banners_direct,
            '--yandexuids', self.Parameters.yandexuids,
            '--supermoderation-url', self.Parameters.supermoderation_url,
            '--state', self.Parameters.state,
            '--directory-src', self.Parameters.directory_src,
            '--directory-dst', self.Parameters.directory_dst,
            '--output-format', self.Parameters.output_format,
            '--big-intermediate-dir', self.Parameters.big_intermediate_dir,
            '--debug-dir', self.Parameters.debug_dir,
            '--max-tables-count-to-keep-in-state', self.Parameters.max_tables_count_to_keep_in_state,
            '--no-input-failure-interval-hours', self.Parameters.no_input_failure_interval_hours,
        ]
        if self.Parameters.save_big_intermediate:
            binary_cmd.append('--save-big-intermediate')
        if self.Parameters.save_debug:
            binary_cmd.append('--save-debug')
        self.run_command(binary_cmd)
