# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertAbuseLogsProcessor(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-704: Process raw BS abuse logs and aggregate by banners
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with bs abuse logs processor binary',
                resource_type=[resource_types.MODADVERT_ABUSE_LOGS_PROCESSOR],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            bs_abuse_logs_path = sdk2.parameters.String('BS abuse logs path', default='//logs/bs-abuse-log/30min')
            base_path = sdk2.parameters.String('Base path', default='//home/modadvert')

    def on_before_execute(self):
        super(modadvert.ModadvertBaseYtTask, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './bs_abuse_logs_processor',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--bs-abuse-logs-path', self.Parameters.bs_abuse_logs_path,
            '--base-path', self.Parameters.base_path
        ]

        self.run_command(binary_cmd)
