# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertAbuseLyncherResultsGrepper(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-825: Find lyncher results for abused banners.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with Lyncher results grepper binary',
                resource_type=[resource_types.MODADVERT_ABUSE_LYNCHER_RESULTS_GREPPER],
                required=True
            )

        with modadvert.ModadvertBaseYtTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='hahn')

        with sdk2.parameters.Group('Lyncher results options') as lyncher_results_options_group:
            lyncher_results = sdk2.parameters.List(
                'Lyncher results paths',
                default=['//home/modadvert/lyncher/Results']
            )
            lyncher_results_offset_days = sdk2.parameters.Integer(
                'Days to look back in time for Lyncher results',
                default=7
            )

        with sdk2.parameters.Group('Abuses options') as abuses_options_group:
            directory_src = sdk2.parameters.String(
                'Directory with aggregated abuses',
                default='//home/modadvert/abuse'
            )
            tables_format = sdk2.parameters.String(
                'Abuse tables format containing timestamp',
                default='ModAbuseBanners%Y%m%d'
            )

        with sdk2.parameters.Group('Perfomance details') as perfomance_options_group:
            chunk_size = sdk2.parameters.Integer('Insert rows chunk size', default=1000)
            max_tables_count_to_produce_at_once = sdk2.parameters.Integer('Max tables count to produce at once', default=2)

        with sdk2.parameters.Group('Output options') as output_options_group:
            table_dst = sdk2.parameters.String(
                'Destination table',
                default='//home/modadvert/abuse/LyncherResultsAbused'
            )

    def on_before_execute(self):
        super(ModadvertAbuseLyncherResultsGrepper, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './lyncher_results',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--lyncher-results-offset-days', self.Parameters.lyncher_results_offset_days,
            '--directory-src', self.Parameters.directory_src,
            '--tables-format', self.Parameters.tables_format,
            '--chunk-size', self.Parameters.chunk_size,
            '--max-tables-count-to-produce-at-once', self.Parameters.max_tables_count_to_produce_at_once,
            '--table-dst', self.Parameters.table_dst,
        ]
        binary_cmd.extend(['--lyncher-results'] + self.Parameters.lyncher_results)
        self.run_command(binary_cmd)
