# -*- coding: utf-8 -*-
import sandbox.common.types.client as ctc
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertAntispamAdapter(modadvert.ModadvertBaseRunSupermoderation):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseRunSupermoderation.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with antispam adapter binary',
                resource_type=[resource_types.MODADVERT_ANTISPAM_ADAPTER_BINARY],
                required=True
            )

        with modadvert.ModadvertBaseRunSupermoderation.Parameters.clusters_group() as clusters_group:
            yt_write_proxy_url = modadvert.YtCluster('YT worker cluster', default='arnold')

    def create_command(self):
        cmd = super(ModadvertAntispamAdapter, self).create_command()
        cmd.extend(['--yt-write-proxy-url', self.Parameters.yt_write_proxy_url])
        return cmd
