# -*- coding: utf-8 -*-
import json

from sandbox import sdk2
from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertAntivirVerdictsLagMetrics(modadvert.ModadvertBaseYtTask):
    """
    MODDEV-376: Antivir verdict pass time metrics.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):

        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with antivir_verdicts_lag_metrics binary',
                resource_type=[resource_types.MODADVERT_ANTIVIR_VERDICTS_LAG_METRICS],
                required=True
            )

        with sdk2.parameters.Group('Source options') as source_options_group:
            heavy_operation_yt_proxy_url = modadvert.YtCluster(
                'YT cluster for heavy operations',
                default='arnold',
            )
            requests_dir = sdk2.parameters.String(
                'Antivir requests directory',
                default='//home/antivir/export/direct-moderate/direct-checker/verdicts',
            )
            verdicts_table = sdk2.parameters.String(
                'SM Verdicts table path',
                default='//home/modadvert/supermoderation/Verdicts',
            )
            state = sdk2.parameters.String(
                'State path',
                default='//home/modadvert/states/antivir_verdicts_lag_metrics/produced_tables',
            )
            lookback_interval = sdk2.parameters.JSON(
                'Lookback time interval',
                default={'days': 7},
            )

        with sdk2.parameters.Group('Debug options') as debug_options_group:
            intermediate_dir = sdk2.parameters.String(
                'Intermediate dir path',
                default='//tmp/robot-modadvert-yt/antivir_verdicts_lag_metrics',
            )

        with sdk2.parameters.Group('Plot options') as plot_options_group:
            granularity = sdk2.parameters.JSON(
                'Granularity',
                default={'minutes': 30},
            )
            percentiles = sdk2.parameters.List(
                'Percentiles',
                default=[50, 75, 95, 100],
            )
            plot_by_end_time = sdk2.parameters.Bool(
                'Plot by end time',
                default=False,
            )

        with sdk2.parameters.Group('Solomon options') as solomon_options_group:
            send_metrics = sdk2.parameters.Bool(
                'Send metrics',
                default=True,
            )
            testing = sdk2.parameters.Bool(
                'Testing Solomon',
                default=False,
            )
            solomon_service = sdk2.parameters.String(
                'Solomon service',
                default='modadvert',
            )
            solomon_cluster = sdk2.parameters.String(
                'Solomon cluster',
                default='circuit',
            )
            solomon_common_labels = sdk2.parameters.JSON(
                'Solomon common labels',
                default={'sensor_type': 'verdict_pass_time'},
            )

    def on_before_execute(self):
        super(ModadvertAntivirVerdictsLagMetrics, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './antivir_verdicts_lag_metrics',
            '--heavy-operation-yt-proxy-url', self.Parameters.heavy_operation_yt_proxy_url,
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--requests-dir', self.Parameters.requests_dir,
            '--verdicts-table', self.Parameters.verdicts_table,
            '--state', self.Parameters.state,
            '--lookback-interval', json.dumps(self.Parameters.lookback_interval),
            '--intermediate-dir', self.Parameters.intermediate_dir,
            '--granularity', json.dumps(self.Parameters.granularity),
            '--solomon-service', self.Parameters.solomon_service,
            '--solomon-cluster', self.Parameters.solomon_cluster,
            '--solomon-common-labels', json.dumps(self.Parameters.solomon_common_labels),
        ]
        if self.Parameters.plot_by_end_time:
            binary_cmd.append('--plot-by-end-time')
        if self.Parameters.send_metrics:
            binary_cmd.append('--send-metrics')
        if self.Parameters.testing:
            binary_cmd.append('--testing')
        binary_cmd.extend(['--percentiles'] + self.Parameters.percentiles)

        self.run_command(binary_cmd)
