# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.common import modadvert


class ModadvertBrandsClassifierCircuit(modadvert.ModadvertBaseRunSupermoderation):

    class Parameters(modadvert.ModadvertBaseRunSupermoderation.Parameters):
        with sdk2.parameters.Group('Binaries') as binaries_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with brands classifier binary',
                resource_type=resource_types.MODADVERT_BRANDS_CLASSIFIER_CIRCUIT
            )
            brands_config = sdk2.parameters.Resource(
                'Resource with brands config',
                resource_type=resource_types.BRANDS_CONFIG_TYPES,
            )
            threads_count = sdk2.parameters.Integer('Send threads count', required=False, default=10)
            request_chunk_size = sdk2.parameters.Integer('Request chunk size', required=False, default=5000)

    def on_before_execute(self):
        super(ModadvertBrandsClassifierCircuit, self).on_before_execute()
        self.untar_resource(self.Parameters.brands_config, dst_dir='brands')

    def create_command(self):
        result = super(ModadvertBrandsClassifierCircuit, self).create_command()
        result += [
            '--brands-conf', './brands/config.yaml',
            '--threads-count', str(self.Parameters.threads_count),
            '--request-chunk-size', str(self.Parameters.request_chunk_size),
        ]
        return result
