# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertBsPriorityThreshold(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-780: Write priority clients with thresholds.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with bs priority thresholds writer',
                resource_type=resource_types.MODADVERT_BS_PRIORITY_THRESHOLD,
                required=True
            )

        with sdk2.parameters.Group('Input options') as input_options_group:
            state_path = sdk2.parameters.String('State path', default='//home/modadvert/BsPriorityThreshold/state')
            high_clients_table = sdk2.parameters.String('High-priority clients table', default='//home/modadvert/ClientPrioritiesHigh')
            medium_clients_table = sdk2.parameters.String('Medium-priority clients table', default='//home/modadvert/ClientPrioritiesMedium')
            add_manual_thresholds = sdk2.parameters.Bool('Use manual thresholds', default=False)
            manual_thresholds_table = sdk2.parameters.String('Manual thresholds table', default='//home/modadvert/ManualThresholds')
        with sdk2.parameters.Group('Thresholds') as thresholds_options_group:
            threshold_a = sdk2.parameters.Integer('High priority', default=30)
            threshold_b = sdk2.parameters.Integer('Mdium priority', default=20)
        with sdk2.parameters.Group('Output options') as output_options_group:
            yt_proxy_url_master = modadvert.YtCluster('Replication cluster', default='markov')
            destination_table = sdk2.parameters.String('Thresholds table', default='//home/modadvert/export/bs/AbuseClientThreshold')
            chunk_size = sdk2.parameters.Integer('Dynamic table insertion chunk size', default=1000)
            insertion_retry_count = sdk2.parameters.Integer('Insertion retries count', default=5)

    def on_before_execute(self):
        super(modadvert.ModadvertBaseYtTask, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './bs_priority_threshold',
            '--yt-worker-proxy-url', self.Parameters.yt_proxy_url,
            '--state-path', self.Parameters.state_path,
            '--high-clients-table', self.Parameters.high_clients_table,
            '--medium-clients-table', self.Parameters.medium_clients_table,
            '--threshold-a', self.Parameters.threshold_a,
            '--threshold-b', self.Parameters.threshold_b,
            '--yt-proxy-url', self.Parameters.yt_proxy_url_master,
            '--destination-table', self.Parameters.destination_table,
            '--chunk-size', self.Parameters.chunk_size,
            '--insertion-retry-count', self.Parameters.insertion_retry_count,
        ]
        if self.Parameters.add_manual_thresholds:
            binary_cmd.extend(['--manual-thresholds', self.Parameters.manual_thresholds_table])
        self.run_command(binary_cmd)
