# -*- coding: utf-8 -*-
import os
from sandbox import sdk2
from sandbox.projects.modadvert.BuildLaaS import ModadvertBuildLaaS
from sandbox.projects.modadvert.common.modadvert import ModadvertBaseTask
from sandbox.projects.modadvert.rm.constants import CUPID_CONFIGS_PATH, CUPID_OBJECT_TYPES

class ModadvertBuildCupid(ModadvertBaseTask):
    """
    Builds in-memory, HTTP, MR runners and docker image for each supported object types
    defined in `object_types` parameter.
    Directory `base_configs_path` should have sub-directories with names from `object_types`.
    Each sub-directory should have 'workers.yaml' (configuration of pipeline) and 'peerdirs.json' (necessary dependencies) files.
    NOTE: built resources won't appear into Resources section of this task. All built resources will be attached
    to MODADVERT_BUILD_LAAS subtasks
    """

    class Parameters(ModadvertBaseTask.Parameters):

        kill_timeout = 12 * 60 * 60  # 12h

        with sdk2.parameters.Group('Build configuration'):
            base_configs_path = sdk2.parameters.String(
                "Arcadia path to directory with workers' configs",
                default=CUPID_CONFIGS_PATH
            )
            checkout_arcadia_from_url = ModadvertBuildLaaS.Parameters.checkout_arcadia_from_url()
            object_types = sdk2.parameters.List(
                'List of supported object types',
                default=CUPID_OBJECT_TYPES
            )

        with sdk2.parameters.Group('Release configuration'):
            release_number = ModadvertBuildLaaS.Parameters.release_number()

    def _create_build_subtask(self, object_type):
        subtask_parameters = {
            ModadvertBuildLaaS.Parameters.binary_executor_release_type.name: 'stable',
            ModadvertBuildLaaS.Parameters.workers_path.name: os.path.join(self.Parameters.base_configs_path, object_type, 'workers.yaml'),
            ModadvertBuildLaaS.Parameters.peerdirs_path.name: os.path.join(self.Parameters.base_configs_path, object_type, 'peerdirs.json'),
            ModadvertBuildLaaS.Parameters.checkout_arcadia_from_url.name: self.Parameters.checkout_arcadia_from_url,
            ModadvertBuildLaaS.Parameters.component_name.name: 'cupid',
            ModadvertBuildLaaS.Parameters.release_number.name: self.Parameters.release_number,
            ModadvertBuildLaaS.Parameters.resource_attributes.name: {'object_type': object_type},
        }
        return self.create_subtask(
            ModadvertBuildLaaS,
            subtask_parameters,
            'Build Cupid binaries for "{}"'.format(object_type)
        )

    def on_execute_inner(self):
        for object_type in self.Parameters.object_types:
            subtask_key = '{}_build_subtask'.format(object_type)
            if not getattr(self.Context, subtask_key):
                setattr(self.Context, subtask_key, self._create_build_subtask(object_type))
        self.wait_all_subtasks()
