# -*- coding: utf-8 -*-
def create_patch(arcadia_url, build_paths, workers_path, peerdirs_path=None):
    import json
    import os
    import sandbox.sdk2 as sdk2
    from modadvert.libs.laas.patch import create_config_patch, create_ya_make_patch

    if '@' in arcadia_url:
        arcadia_path, arcadia_revision = arcadia_url.rsplit('@', 1)
    else:
        arcadia_path, arcadia_revision = arcadia_url, None

    patches = []
    workers = sdk2.svn.Arcadia.cat(os.path.join(arcadia_path, workers_path), revision=arcadia_revision)
    peerdirs = None
    if peerdirs_path is not None:
        peerdirs = sdk2.svn.Arcadia.cat(os.path.join(arcadia_path, peerdirs_path), revision=arcadia_revision)
    for project_path in build_paths:
        patches.append(create_config_patch(project_path, workers))
        if peerdirs is not None:
            ya_make = sdk2.svn.Arcadia.cat(os.path.join(arcadia_path, project_path, 'ya.make'), revision=arcadia_revision)
            patches.append(create_ya_make_patch(project_path, ya_make, json.loads(peerdirs)))
    return ''.join(patches)
