# -*- coding: utf-8 -*-
import logging
import os
from sandbox import sandboxsdk
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.input_params as rm_params

from sandbox.common.utils import get_resource_link, get_task_link
from sandbox.sandboxsdk.channel import channel
from sandbox.projects.common.build.parameters import ArcadiaUrl
from sandbox.projects.common.build.YaPackage import YaPackage
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper
from sandbox.projects.release_machine.components import all as rmcs
from sandbox.projects.release_machine.components.configs.supermoderation import SupermoderationCfg
from sandbox.projects.modadvert.common.constants import STARTREK_CLIENT_ENVIROMENTS


class ModAdvertBuildTask(YaPackage, object):

    type = 'MODADVERT_BUILD_TASK'

    environment = STARTREK_CLIENT_ENVIROMENTS

    class ComponentName(rm_params.ComponentName):
        default_value = SupermoderationCfg.name

    class ReleaseNumber(sandboxsdk.parameters.SandboxStringParameter):
        required = False
        name = 'release_number'
        description = name
        default_value = ''

    input_parameters = [ComponentName, ReleaseNumber] + YaPackage.input_parameters

    def get_c_info(self):
        return rmcs.COMPONENTS[self.ctx[self.ComponentName.name]]()

    def get_resources_info(self):
        resources = channel.sandbox.list_resources(task_id=self.id, limit=100)
        return sorted((str(resource.type), resource.id) for resource in resources if str(resource.type) not in ('TASK_LOGS', 'BUILD_LOGS'))

    def on_execute(self):
        super(ModAdvertBuildTask, self).on_execute()

        resources = self.get_resources_info()
        pattern = '|| {} | (({} {})) ||'
        resource_info = '\n'.join([pattern.format(r_type, get_resource_link(r_id), r_id) for r_type, r_id in resources])
        message = (
            'Build task (({} {})) finished. Resources list:\n'
            '#|\n'
            '**|| Resource type | Resource link ||**\n'
            '{}\n'
            '|#'
        ).format(
            get_task_link(self.id),
            self.id,
            resource_info
        )

        release_number = self.ctx[self.ReleaseNumber.name]
        if release_number:
            c_info = self.get_c_info()
            st_helper = STHelper(self.get_vault_data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
            st_helper.comment(
                release_number,
                message,
                c_info
            )
        else:
            logging.info(message)


__Task__ = ModAdvertBuildTask
