# -*- coding: utf-8 -*-
import sandbox.common.types.client as ctc
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class CVIndexer(modadvert.ModadvertBaseRunSupermoderation):

    name = 'MODADVERT_CV_INDEXER'

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseRunSupermoderation.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with CV indexer binary',
                resource_type=[resource_types.MODADVERT_CV_INDEXER_BINARY],
                required=True
            )
