# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertCVRejectedMetrics(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-561: Find duplicates which verdicts differ from the original ones.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with cv_rejected_metrics binary',
                resource_type=[resource_types.MODADVERT_CV_REJECTED_METRICS],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            table_rejected = sdk2.parameters.String(
                'ImgManualRejects path',
                default='//home/modadvert/ImgManualRejects'
            )
            table_results = sdk2.parameters.String(
                'Destination table path',
                default='//home/modadvert/test/vlad-mois/cv-rejected-monitoring'
            )

    def on_before_execute(self):
        super(ModadvertCVRejectedMetrics, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './cv_rejected_metrics',
            '--cluster', self.Parameters.yt_proxy_url,
            '--table-rejected', self.Parameters.table_rejected,
            '--table-results', self.Parameters.table_results
        ]
        self.run_command(binary_cmd)
