# -*- coding: utf-8 -*-

import logging

import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters

from sandbox.projects.modadvert import resource_types
from sandbox.projects.common.apihelpers import get_last_resource_with_attribute


CONFIG_GROUP = "General configuration"
TASK_GROUP = "Task configuration"


class ModAdvertCatalogiaFlagsDiff(sdk_task.SandboxTask):
    type = "MODADVERT_CATALOGIA_FLAGS_DIFF"
    client_tags = ctc.Tag.LINUX_PRECISE

    class YTProxyUrl(sdk_parameters.SandboxStringParameter):
        group = CONFIG_GROUP
        name = "yt_proxy_url"
        description = name
        default_value = "hahn.yt.yandex.net"

    class VaultUser(sdk_parameters.SandboxStringParameter):
        group = CONFIG_GROUP
        name = "vault_user"
        description = name
        default_value = "MODADVERT"

    class YTTokenVaultName(sdk_parameters.SandboxStringParameter):
        group = CONFIG_GROUP
        name = "yt_token_vault_name"
        description = name
        default_value = "yt-token"

    class InputFlagsTable(sdk_parameters.SandboxStringParameter):
        group = TASK_GROUP
        name = "input_flags_table"
        description = name
        default_value = "//home/catalogia/banners-recategorized-fast"

    class DirectDbTable(sdk_parameters.SandboxStringParameter):
        group = TASK_GROUP
        name = "direct_db_table"
        description = name
        default_value = "//home/direct/db/banners"

    class HandledFlags(sdk_parameters.SandboxStringParameter):
        group = TASK_GROUP
        name = "handled_flags"
        description = name
        default_value = ""

    class YTWorkingDir(sdk_parameters.SandboxStringParameter):
        group = TASK_GROUP
        name = "yt_working_dir"
        description = name
        default_value = "//home/modadvert/catalogia_flags_diff/"

    input_parameters = [
        YTProxyUrl,
        VaultUser,
        YTTokenVaultName,
        InputFlagsTable,
        DirectDbTable,
        HandledFlags,
        YTWorkingDir,
    ]

    def on_execute(self):
        logging.info('starting ModAdvertCatalogiaFlagsDiff on_execute()...')

        resource = get_last_resource_with_attribute(
            resource_types.YA_PACKAGE,
            "resource_name",
            "catalogia-flags-diff-binary"
        )
        logging.info(str(resource))

        tarball_path = self.sync_resource(resource)

        from projects.modadvert.common.utils import run_command_with_livelog

        unpack_binary_cmd = ['tar', '-xvf', tarball_path]
        get_catalogia_flags_diff_cmd = [
            "./catalogia_flags_diff",
            "--yt-proxy-url", self.ctx[self.YTProxyUrl.name],
            "--input-flags-table", str(self.ctx[self.InputFlagsTable.name]),
            "--direct-db-table", str(self.ctx[self.DirectDbTable.name]),
        ]

        if self.ctx.get(self.HandledFlags.name):
            get_catalogia_flags_diff_cmd.extend([
                "--handled-flags", str(self.ctx[self.HandledFlags.name]),
            ])
        if self.ctx.get(self.YTWorkingDir.name):
            get_catalogia_flags_diff_cmd.extend([
                "--yt-working-dir", str(self.ctx[self.YTWorkingDir.name]),
            ])

        run_command_with_livelog(unpack_binary_cmd)
        run_command_with_livelog(
            get_catalogia_flags_diff_cmd,
            env={
                'YT_TOKEN': self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YTTokenVaultName.name)),
            }
        )

        logging.info('finished ModAdvertCatalogiaFlagsDiff on_execute()')


__Task__ = ModAdvertCatalogiaFlagsDiff
