#!/usr/bin/env python
# -*-  coding: utf8 -*

# This script is intentionally made in old style because it should be launched ASAP

import sys
import json
import logging
import os
import subprocess
import random

from sandbox.projects.modadvert.common.ytutils import yt_connect


def run(**kwargs):
    p = subprocess.Popen(
        [sys.executable, __file__],
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE
    )
    (out, err) = p.communicate(input=json.dumps(kwargs))
    if err:
        logging.error(err)
    if p.returncode:
        raise Exception("run exited with code: {:d}".format(p.returncode))
    if out:
        return out


class Mapper(object):
    def __init__(self, analyze_date):
        self.datetime_minimum = '{} 00:00:00'.format(analyze_date)
        self.datetime_maximum = '{} 23:59:59'.format(analyze_date)

    def __call__(self, row):
        if self.datetime_minimum <= row['start_time'] <= self.datetime_maximum and row['verdict'] != 'NA':
            yield row


def get_banner(row):
    return [
        row['meta']['banner_id'],
        row['data']['title'],
        row['data']['body'],
        row['data']['domain'],
    ]


def format_block(rule, banners, sample_size):
    result = '<h2>' + rule + '</h2>'
    result += '''
        <br>
        <table border="1">
            <tr>
                <td><b>bid</b></td>
                <td><b>title</b></td>
                <td><b>body</b></td>
                <td><b>domain</b></td>
            </tr>
    '''
    random.shuffle(banners)
    cur_slice = banners[:sample_size]
    directmod = 'https://direct-mod.yandex-team.ru/history/banner/?bid='
    for banner in cur_slice:
        result += '''
            <tr>
                <td><a href="{directmod}{banner[0]}">{banner[0]}</a></td>
                <td>{banner[1]}</td>
                <td>{banner[2]}</td>
                <td><a href="https://h.yandex-team.ru/?http://{banner[3]}">{banner[3]}</a></td>
            </tr>
        '''.format(banner=banner, directmod=directmod)
    return result + '</table>'


def main(params):
    random.seed(1147)
    yt_client = yt_connect(
        params['yt_proxy_url'],
        params['yt_token'],
    )
    # You can pass either full Results table or directory with "{datetime}-{object_type}" result tables.
    if yt_client.get_type(params['result_table']) == 'table':
        input_table = params['result_table']
    else:
        input_table = list(yt_client.search(
            params['result_table'],
            node_type='table',
            path_filter=lambda table: table.endswith('banner'),
        ))[-1]

    bids = {}
    with yt_client.TempTable() as temp_table:
        yt_client.run_map(
            Mapper(params['analyze_date']),
            input_table,
            temp_table,
        )

        for row in yt_client.read_table(temp_table):
            for key in row:
                if key.startswith('r_verdict_') and row[key] != 'NA':
                    rule = key[10:][:-4] + ', ' + row[key]
                    if rule not in bids:
                        bids[rule] = []
                    bids[rule].append(get_banner(row))

    result = []
    for rule, banners in bids.iteritems():
        result.append(format_block(rule, banners, int(params['sample_size'])))

    return '<br><br>'.join(result)


if __name__ == "__main__":
    input_params = json.load(sys.stdin)
    print main(input_params)
