# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertCleanData(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-894: Run a binary file with the corresponding config to clean up data in different clusters.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with old tables cleaner',
                resource_type=[resource_types.MODADVERT_CLEAN_DATA_BINARY],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            config_name = sdk2.parameters.String(
                'Config name',
                default='./config.yaml'
            )

    def on_before_execute(self):
        super(ModadvertCleanData, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './clean_data',
            '--conf', self.Parameters.config_name,
        ]
        self.run_command(binary_cmd)
