from sandbox import sdk2
from sandbox.projects.modadvert.common import modadvert


class ModadvertClientDomainStat(modadvert.ModadvertBaseRunBinaryTask):
    resource_name = 'modadvert-client-domain-stat'

    class Parameters(modadvert.ModadvertBaseRunBinaryTask.Parameters):
        yql_oauth_token_vault_name = sdk2.parameters.String('YQL OAuth token vault name', default='yql-oauth-token')
        result_yt_dir = sdk2.parameters.String('Result YT dir')

    def get_yql_oauth_token(self):
        return sdk2.Vault.data(self.Parameters.vault_user, self.Parameters.yql_oauth_token_vault_name)

    def create_env(self):
        env = super(ModadvertClientDomainStat, self).create_env()
        env['YQL_TOKEN'] = self.get_yql_oauth_token()
        env['YT_TOKEN'] = self.get_yt_token()
        return env

    def create_command(self):
        command = [
            './client_domain_stat',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--result-yt-dir', self.Parameters.result_yt_dir,
        ]
        return command
