# -*- coding: utf-8 -*-

import logging
import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters

from sandbox.projects.modadvert import resource_types
from sandbox.projects.common.apihelpers import get_last_resource_with_attribute


CONFIG_GROUP = "General configuration"
CLIENT_FACTORS_GROUP = "Client factors"
DYNAMISE_CLIENT_FACTORS_TOTAL_GROUP = "Dynamise Client factors total"


class ModAdvertClientFactors(sdk_task.SandboxTask):
    type = "MODADVERT_CLIENT_FACTORS"
    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1
    required_ram = 2 * 1024
    execution_space = 10 * 1024

    class YtProxyUrl(sdk_parameters.SandboxStringParameter):
        group = CONFIG_GROUP
        name = "yt_proxy_url"
        description = name
        default_value = "hahn.yt.yandex.net"

    class VaultUser(sdk_parameters.SandboxStringParameter):
        group = CONFIG_GROUP
        name = "vault_user"
        description = name
        default_value = "MODADVERT"

    class YtTokenVaultName(sdk_parameters.SandboxStringParameter):
        group = CONFIG_GROUP
        name = "yt_token_vault_name"
        description = name
        default_value = "yt-token"

    class Type(sdk_parameters.SandboxStringParameter):
        group = CLIENT_FACTORS_GROUP
        name = "type"
        description = name

    class DstTable(sdk_parameters.SandboxStringParameter):
        group = CLIENT_FACTORS_GROUP
        name = "dst_table"
        description = name
        default_value = "//home/modadvert/ClientFactors"

    class DstDynamicTablePartial(sdk_parameters.SandboxStringParameter):
        group = CLIENT_FACTORS_GROUP
        name = "dst_dynamic_table_partial"
        description = name
        default_value = "//home/modadvert/ClientFactorsDynamic"

    class TableStartIndex(sdk_parameters.SandboxStringParameter):
        group = CLIENT_FACTORS_GROUP
        name = "table_start_index"
        description = name
        default_value = ""

    class TableEndIndex(sdk_parameters.SandboxStringParameter):
        group = CLIENT_FACTORS_GROUP
        name = "table_end_index"
        description = name
        default_value = ""

    class ClientFactorsTotalTable(sdk_parameters.SandboxStringParameter):
        group = DYNAMISE_CLIENT_FACTORS_TOTAL_GROUP
        name = "client_factors_total_table"
        description = name
        default_value = "//home/modadvert/ClientFactorsTotal"

    class ClientFactorsTotalDynamicTable(sdk_parameters.SandboxStringParameter):
        group = DYNAMISE_CLIENT_FACTORS_TOTAL_GROUP
        name = "client_factors_total_dynamic_table"
        description = name
        default_value = "//home/modadvert/ClientFactorsTotalDynamic"

    input_parameters = [
        YtProxyUrl,
        VaultUser,
        YtTokenVaultName,
        Type,
        DstTable,
        TableStartIndex,
        TableEndIndex,
        DstDynamicTablePartial,
        ClientFactorsTotalTable,
        ClientFactorsTotalDynamicTable,
    ]

    def on_execute(self):
        logging.info('starting ModAdvertClientFactors on_execute()...')

        resource = get_last_resource_with_attribute(
            resource_types.YA_PACKAGE,
            "resource_name",
            "modadvert-client-factors"
        )
        logging.info(str(resource))

        tarball_path = self.sync_resource(resource)

        from projects.modadvert.common.utils import run_command_with_livelog

        unpack_binary_cmd = ['tar', '-xvf', tarball_path]
        collect_client_factors_cmd = [
            "./client_factors",
            "--yt-proxy-url", self.ctx[self.YtProxyUrl.name],
            "--type", str(self.ctx[self.Type.name]),
            "--dst-static-table", str(self.ctx[self.DstTable.name]),
            "--dst-dynamic-table-partial", str(self.ctx[self.DstDynamicTablePartial.name]),
            "--client-factors-total", str(self.ctx[self.ClientFactorsTotalTable.name]),
            "--dst-dynamic-table", str(self.ctx[self.ClientFactorsTotalDynamicTable.name])
        ]

        if self.ctx.get(self.TableStartIndex.name):
            collect_client_factors_cmd.extend([
                "--start-index", str(self.ctx[self.TableStartIndex.name])
            ])
        if self.ctx.get(self.TableStartIndex.name):
            collect_client_factors_cmd.extend([
                "--end-index", str(self.ctx[self.TableEndIndex.name])
            ])

        run_command_with_livelog(unpack_binary_cmd)
        run_command_with_livelog(
            collect_client_factors_cmd,
            env={
                'YT_TOKEN': self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YtTokenVaultName.name)),
            }
        )

        logging.info('finished ModAdvertClientFactors on_execute()')


__Task__ = ModAdvertClientFactors
