# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.client as ctc


from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertCreateSMDatabase(modadvert.ModadvertBaseYtTask):

    name = 'MODADVERT_CREATE_SM_DATABASE'

    class Requirements(sdk2.task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with task binary',
                resource_type=resource_types.MODADVERT_CREATE_SM_DATABASE_BINARY,
                required=True
            )
        sync_cluster = sdk2.parameters.String('Yt sync cluster', required=True, default='hahn')
        async_cluster = sdk2.parameters.String('Yt async cluster', required=True, default='arnold')
        src_dir = sdk2.parameters.String('Source yt directory', required=True)
        dst_dir = sdk2.parameters.String('Destination yt directory', required=True)
        original_dir = sdk2.parameters.String('Original yt directory', required=True)

    def create_command(self):
        cmd = [
            './create_tables_for_testing',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--sync-cluster', self.Parameters.sync_cluster,
            '--async-cluster', self.Parameters.async_cluster,
            '--src-dir-path', self.Parameters.src_dir,
            '--dst-dir-path', self.Parameters.dst_dir,
            '--original-dir-path', self.Parameters.original_dir
        ]
        return cmd

    def on_execute_inner(self):
        self.untar_resource(self.Parameters.binaries_resource)
        self.run_command(self.create_command(), log_prefix="main", env=self.create_env())
