# -*- coding: utf-8 -*-
from sandbox import sdk2

from datetime import datetime, timedelta
from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertCreateSMStaticTables(modadvert.ModadvertBaseYtTask):

    name = 'MODADVERT_CREATE_SM_STATIC_TABLES'

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with task binary',
                resource_type=resource_types.MODADVERT_CREATE_SM_STATIC_TABLES_BINARY,
                required=True
            )
        start_time = sdk2.parameters.Float('Start collecting sample since this many days', required=True, default=4.)
        end_time = sdk2.parameters.Float('Start collecting requests since this many days ago', required=True, default=1.)
        offset_days = sdk2.parameters.Float('Offset days (shift to existing logs)', required=True, default=1.)
        src_dir = sdk2.parameters.String('DB source directory', required=True, default='//home/modadvert/supermoderation')
        dst_dir = sdk2.parameters.String('New DB destination directory', required=True, default='//home/modadvert/test')
        requests_src_dir = sdk2.parameters.String('Requests source directory', required=True, default='//logs/modadvert-http-log/1d')

    def calc_days_before(self, days_ago):
        answer = datetime.now() - timedelta(days_ago)
        return datetime.strftime(answer, '%Y-%m-%d %H:%M:%S')

    def create_command(self):
        cmd = [
            './create_tables',
            '--start-time', self.calc_days_before(self.Parameters.start_time + self.Parameters.offset_days),
            '--end-time', self.calc_days_before(self.Parameters.end_time + self.Parameters.offset_days),
            '--end-requests-time', self.calc_days_before(self.Parameters.offset_days),
            '--src-dir-path', self.Parameters.src_dir,
            '--dst-dir-path', self.Parameters.dst_dir,
            '--requests-src-dir', self.Parameters.requests_src_dir,
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
        ]
        return cmd

    def on_execute_inner(self):
        self.untar_resource(self.Parameters.binaries_resource)
        self.run_command(self.create_command(), log_prefix="main")
