# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.ModadvertDeployTask import ModadvertDeployTask

from sandbox.projects.release_machine.components.configs.brands import BrandsCfg


TESTING = 'TESTING'
PROD = 'PROD'


CONFIG_RESOURCES = {
    'config': resource_types.SUPERMODERATION_CONFIG_TYPES,
    'service_confs': resource_types.SUPERMODERATION_SERVICE_CONFIG_TYPES
}


class ModadvertDeployBrands(ModadvertDeployTask):

    ADDITIONAL_PARAMETERS = [
        'brands_classifier_resource',
        'brands_config_resource',
        'brands_classifier_binaries_resource',
    ]
    COMPONENT = BrandsCfg.name
    ENV_NAMES = {
        TESTING: 'testing',
        PROD: 'production'
    }
    RELEASE_COMPONENTS = ['api']
    SCHEDULERS = {
        'classifier_circuit': {
            'description': '<a href="https://st.yandex-team.ru/MODADVERT-607">MODADVERT-607</a>: Run brands classifier circuit <b>PROD</b>',
            'environments': {
                PROD: 8541,
            },
            'resources': {
                'brands_config': resource_types.BRANDS_CONFIG_TYPES,
            }
        },
        'classifier_banners': {
            'description': 'MODADVERT-532: Run brands classifier',
            'environments': {
                PROD: 8540,
            },
            'resources': {
                'classifier_resource': resource_types.MODADVERT_BRANDS_CLASSIFIER,
                'brands_config_resource': resource_types.BRANDS_CONFIG_TYPES,
            }
        },
        'classifier_media': {
            'description': 'MODADVERT-532: Run brands classifier for media formats',
            'environments': {
                PROD: 8555,
            },
            'resources': {
                'classifier_resource': resource_types.MODADVERT_BRANDS_CLASSIFIER,
                'brands_config_resource': resource_types.BRANDS_CONFIG_TYPES,
            }
        },
        'brands_classifier': {
            'description': '<a href="https://st.yandex-team.ru/MODADVERT-607">MODADVERT-607</a>: Run brands classifier circuit',
            'resources': dict(
                CONFIG_RESOURCES,
                binaries_resource=resource_types.MODADVERT_BRANDS_CLASSIFIER_CIRCUIT,
            )
        },
    }

    class Parameters(ModadvertDeployTask.Parameters):
        with sdk2.parameters.String('Release environment', multiline=True) as release_environment:
            release_environment.values.TESTING = release_environment.Value(TESTING, default=True)
            release_environment.values.PROD = release_environment.Value(PROD)

        brands_classifier_resource = sdk2.parameters.Resource(
            'Classifier binaries',
            resource_type=resource_types.MODADVERT_BRANDS_CLASSIFIER
        )
        brands_config_resource = sdk2.parameters.Resource(
            'Brands config',
            resource_type=[resource_types.MODADVERT_BRANDS_CONFIG]
        )
        brands_classifier_binaries_resource = sdk2.parameters.Resource(
            'Brands classifier binaries',
            resource_type=resource_types.MODADVERT_BRANDS_CLASSIFIER_CIRCUIT
        )

    def get_deploying_resources(self):
        return [
            '{}:/conf:{}'.format(release_component, self.Parameters.brands_config_resource.id)
            for release_component in self.RELEASE_COMPONENTS
        ]
