# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.ModadvertDeployTask import ModadvertDeployTask

from sandbox.projects.release_machine.components.configs.lyncher import LyncherCfg
from sandbox.projects.modadvert.common.schedulers_ids import LYNCHER_SCHEDULERS


class ModadvertDeployLyncher(ModadvertDeployTask):

    ADDITIONAL_PARAMETERS = [
        'config_resource',
        'binaries_resource',
        'offline_binaries_resource',
    ]
    COMPONENT = LyncherCfg.name
    ENV_NAMES = {
        'HAHN': 'production',
        'ARNOLD': 'testing',
        'OFFLINE': 'offline'
    }
    SCHEDULERS = {
        'lyncher': {
            'description': 'Run Lyncher',
            'environments': LYNCHER_SCHEDULERS['lyncher'],
            'resources': {
                'binaries_resource': resource_types.MODADVERT_LYNCHER_BINARIES,
                'config_resource': resource_types.MODADVERT_LYNCHER_CONFIG,
            }
        },
        'offline_lyncher': {
            'description': 'Run Lyncher',
            'environments': LYNCHER_SCHEDULERS['offline_lyncher'],
            'resources': {
                'binaries_resource': resource_types.MODADVERT_OFFLINE_LYNCHER_BINARIES,
                'config_resource': resource_types.MODADVERT_LYNCHER_CONFIG,
            }
        },
    }

    @property
    def RELEASE_COMPONENTS(self):
        if self.Parameters.release_environment != 'OFFLINE':
            return ['lyncher']
        return []

    class Parameters(ModadvertDeployTask.Parameters):
        with sdk2.parameters.String('Release environment', multiline=True) as release_environment:
            release_environment.values.ARNOLD = release_environment.Value('ARNOLD', default=True)
            release_environment.values.HAHN = release_environment.Value('HAHN')
            release_environment.values.OFFLINE = release_environment.Value('OFFLINE')

        binaries_resource = sdk2.parameters.Resource(
            'Lyncher binaries',
            resource_type=resource_types.MODADVERT_LYNCHER_BINARIES
        )
        offline_binaries_resource = sdk2.parameters.Resource(
            'Offline Lyncher binaries',
            resource_type=resource_types.MODADVERT_OFFLINE_LYNCHER_BINARIES
        )
        config_resource = sdk2.parameters.Resource(
            'Moderation adapter binaries',
            resource_type=resource_types.MODADVERT_LYNCHER_CONFIG
        )

    def get_deploying_resources(self):
        return [
            '{}:/conf:{}'.format(release_component, self.Parameters.config_resource.id)
            for release_component in self.RELEASE_COMPONENTS
        ]
