from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.projects.modadvert.common import modadvert


class ModadvertDeployQloudEnvironment(modadvert.ModadvertBaseRunBinaryTask):
    """
    MODADVERT-314: Deploy qloud environment
    """

    resource_name = 'modadvert-qloud-deploy-environment'

    class Parameters(modadvert.ModadvertBaseTask.Parameters):
        with sdk2.parameters.Group('Credentials') as credentials_group:
            vault_user = sdk2.parameters.String('Vault user', default='MODADVERT')
            qloud_token_vault_name = sdk2.parameters.String('Qloud token vault name', default='qloud-token')
            registry_token_vault_name = sdk2.parameters.String('Registry token vault name', default='registry-token')
            sandbox_token_vault_name = sdk2.parameters.String('Sandbox token vault name', default='sandbox-token')
            commit_message = sdk2.parameters.String('Commit message', default='')

        with sdk2.parameters.Group('Resources') as resources_group:
            resources = sdk2.parameters.List(
                'List of deploying resources in format "component_name:resource_link:resource_id"',
                default=[]
            )

        with sdk2.parameters.Group('Deployment parameters') as deployment_group:
            environment_id = sdk2.parameters.String('Environment full ID', default='modadvert.supermoderation.dev')
            components = sdk2.parameters.Dict('Components (key = component name, value = docker image version)')

    def create_env(self):
        return {
            'QLOUD_TOKEN': self.get_author_token(self.Parameters.qloud_token_vault_name, vault_user=self.Parameters.vault_user),
            'REGISTRY_TOKEN': self.get_author_token(self.Parameters.registry_token_vault_name, vault_user=self.Parameters.vault_user),
            'SANDBOX_TOKEN': self.get_author_token(self.Parameters.sandbox_token_vault_name, vault_user=self.Parameters.vault_user),
        }

    def validate(self):
        super(ModadvertDeployQloudEnvironment, self).validate()
        for resource in self.Parameters.resources:
            try:
                component, resource_link, resource_id = resource.split(':')
            except ValueError:
                raise ValueError('Invalid resource format {}. Expected "component_name:resource_link:resource_id"'.format(resource))
            if component not in self.Parameters.components:
                raise ValueError('Expected resource {} to have one of the following components: {} but got {}'.format(resource, self.Parameters.components, component))
            if not resource_link.startswith('/'):
                raise ValueError('Resource link {} should be absolute'.format(resource_link))
            if sdk2.Resource.find(id=resource_id, state=ctr.State.READY).first() is None:
                raise ValueError('Resource with id {} in {} state is not found'.format(resource_id, ctr.State.READY))

    def create_command(self):
        command = [
            './qloud_deploy_environment',
            '--environment-id', self.Parameters.environment_id,
            '--commit-message', '{} .Task ID: {}'.format(self.Parameters.commit_message, self.id),
        ]
        command += ['--resources'] + self.Parameters.resources
        components = self.Parameters.components or {}
        if components:
            command += ['--components'] + ['{}:{}'.format(name, version) for name, version in components.iteritems()]
        return command
