# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.ModadvertDeployTask import ModadvertDeployTask

from sandbox.projects.modadvert.common.schedulers_ids import DEV, DEV2, STAGE, TESTING, PROD, SUPERMODERATION_SCHEDULERS
from sandbox.projects.release_machine.components.configs.supermoderation import SupermoderationCfg


CONFIG_RESOURCES = {
    'config': resource_types.SUPERMODERATION_CONFIG_TYPES,
    'service_confs': resource_types.SUPERMODERATION_SERVICE_CONFIG_TYPES
}


class ModadvertDeploySupermoderation(ModadvertDeployTask):

    ADDITIONAL_PARAMETERS = [
        'saas_indexer_binaries_resource',
        'cv_indexer_binaries_resource',
        'supermoderation_config_resource',
        'supermoderation_services_config_resource',
    ]
    COMPONENT = SupermoderationCfg.name
    ENV_NAMES = {
        DEV: 'dev',
        DEV2: 'dev2',
        STAGE: 'stage',
        TESTING: 'testing',
        PROD: 'production'
    }
    SCHEDULERS_RESOURCES = {
        'saas_indexer': {
            'description': '<a href="https://st.yandex-team.ru/MODADVERT-575">MODADVERT-575</a>: run SaaS indexer',
            'resources': dict(
                CONFIG_RESOURCES,
                binaries_resource=resource_types.MODADVERT_SAAS_INDEXER_BINARY,
            )
        },
        'cv_indexer': {
            'description': '<a href="https://st.yandex-team.ru/DIRECTMOD-9337">DIRECTMOD-9337</a>: run CV indexer',
            'resources': dict(
                CONFIG_RESOURCES,
                binaries_resource=resource_types.MODADVERT_CV_INDEXER_BINARY,
            )
        },
    }
    SCHEDULERS = {
        name: dict(settings, environments=SUPERMODERATION_SCHEDULERS[name])
        for name, settings in SCHEDULERS_RESOURCES.iteritems()
    }

    @property
    def RELEASE_COMPONENTS(self):
        result = ['api', 'admin', 'direct-proxy']
        if self.Parameters.release_environment not in (DEV, DEV2):
            result.append('add-verdicts-api')
        return result

    class Parameters(ModadvertDeployTask.Parameters):
        with sdk2.parameters.String('Release environment', multiline=True) as release_environment:
            release_environment.values.DEV = release_environment.Value(DEV, default=True)
            release_environment.values.DEV2 = release_environment.Value(DEV2)
            release_environment.values.STAGE = release_environment.Value(STAGE)
            release_environment.values.TESTING = release_environment.Value(TESTING)
            release_environment.values.PROD = release_environment.Value(PROD)

        saas_indexer_binaries_resource = sdk2.parameters.Resource(
            'SaaS indexer binaries',
            resource_type=resource_types.MODADVERT_SAAS_INDEXER_BINARY
        )
        cv_indexer_binaries_resource = sdk2.parameters.Resource(
            'CV indexer binaries',
            resource_type=resource_types.MODADVERT_CV_INDEXER_BINARY
        )
        supermoderation_config_resource = sdk2.parameters.Resource(
            'Supermoderation config',
            resource_type=resource_types.SUPERMODERATION_CONFIG_TYPES
        )
        supermoderation_services_config_resource = sdk2.parameters.Resource(
            'Supermoderation services config',
            resource_type=resource_types.SUPERMODERATION_SERVICE_CONFIG_TYPES
        )

    def get_deploying_resources(self):
        # TODO: Remove this after qloud shut down.
        resources = []
        for release_component in self.RELEASE_COMPONENTS:
            resources.extend([
                '{}:/conf:{}'.format(release_component, self.Parameters.supermoderation_config_resource.id),
                '{}:/service_confs:{}'.format(release_component, self.Parameters.supermoderation_services_config_resource.id)
            ])
        return resources

    def get_ydeploy_resources_types_new_versions(self):
        return {
            self.Parameters.supermoderation_config_resource.type.name: self.Parameters.supermoderation_config_resource.id,
            self.Parameters.supermoderation_services_config_resource.type.name: self.Parameters.supermoderation_services_config_resource.id,
        }
