# -*- coding: utf-8 -*-
from sandbox import sdk2


from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertDiffSMResults(modadvert.ModadvertBaseYtTask):

    name = 'MODADVERT_DIFF_SM_RESULTS'

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with task binary',
                resource_type=resource_types.MODADVERT_DIFF_SM_RESULTS_BINARY,
                required=True
            )
        base_sm_dir = sdk2.parameters.String('Base supermoderation directory', required=True)
        feature_sm_dir = sdk2.parameters.String('Feature supermoderation diretory', required=True)
        base_req_log = sdk2.parameters.String('Base requests log table', required=True)
        feature_req_log = sdk2.parameters.String('Feature requests log table', required=True)
        table_diff_dir = sdk2.parameters.String('Difference directory', required=True)

    def create_command(self):
        cmd = [
            './diff_sm_tables',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--base-sm-dir', self.Parameters.base_sm_dir,
            '--feature-sm-dir', self.Parameters.feature_sm_dir,
            '--base-req-log', self.Parameters.base_req_log,
            '--feature-req-log', self.Parameters.feature_req_log,
            '--table-diff-dir', self.Parameters.table_diff_dir,
        ]

        return cmd

    def on_execute_inner(self):
        self.untar_resource(self.Parameters.binaries_resource)
        self.run_command(self.create_command(), log_prefix="main", env=self.create_env())
