# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.common.types.misc import NotExists
from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertDynamicTableInserter(modadvert.ModadvertBaseYtTask):
    """
    MODDEV-630: Copy rows from given table to dynamic table
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):

        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with dynamic_table_inserter binary',
                resource_type=resource_types.MODADVERT_DYNAMIC_TABLE_INSERTER_BINARY
            )

        with sdk2.parameters.Group('Source parameters') as source_group:
            source_table = sdk2.parameters.String('Source YT table', required=True)
            start_index = sdk2.parameters.Integer('Index of start row', default=None)
            end_index = sdk2.parameters.Integer('Index of end row', default=None)
            columns = sdk2.parameters.List('List of columns to copy')

        with sdk2.parameters.Group('Destination parameters') as destination_group:
            destination_table = sdk2.parameters.String('Destination YT table', required=True)
            destination_yt_proxy_url = sdk2.parameters.String('Destination YT proxy url', required=True)
            schema = sdk2.parameters.String('Schema name from modadvert.libs.constants.yt_schemas')
            sync_clusters = sdk2.parameters.List('List of sync clusters')
            async_clusters = sdk2.parameters.List('List of async clusters')

        with sdk2.parameters.Group('Insertion parameters') as insertion_group:
            update = sdk2.parameters.Bool('Update non-existing rows', default=False)
            insertion_chunk_size = sdk2.parameters.Integer('Insertion chunk size', default=50000)
            backoff = sdk2.parameters.Integer('Insertion backoff time in seconds', default=20)
            retry_count = sdk2.parameters.Integer('Number of insertion retries', default=6)

        with sdk2.parameters.Group('Map operation parameters') as map_group:
            user_slots = sdk2.parameters.Integer('Limit of YT user slots', default=30)
            max_failed_job_count = sdk2.parameters.Integer('Limit of failed YT jobs', default=100)
            mapper_memory_limit = sdk2.parameters.Integer('Limit of YT jobs memory', default=10737418240)

        with sdk2.parameters.Group('Static table processing parameters') as static_table_group:
            cast = sdk2.parameters.String('Columns cast type')

    def on_before_execute(self):
        super(ModadvertDynamicTableInserter, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './dynamic_table_inserter',
            '--source-table', self.Parameters.source_table,
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--destination-table', self.Parameters.destination_table,
            '--destination-yt-proxy-url', self.Parameters.destination_yt_proxy_url,
            '--insertion-chunk-size', str(self.Parameters.insertion_chunk_size),
            '--backoff', str(self.Parameters.backoff),
            '--retry-count', str(self.Parameters.retry_count),
            '--user-slots', str(self.Parameters.user_slots),
            '--max-failed-job-count', str(self.Parameters.max_failed_job_count),
            '--mapper-memory-limit', str(self.Parameters.mapper_memory_limit)
        ]
        if self.Parameters.start_index is not None and self.Parameters.start_index is not NotExists:
            binary_cmd.extend(['--start-index', str(self.Parameters.start_index)])
        if self.Parameters.end_index is not None and self.Parameters.end_index is not NotExists:
            binary_cmd.extend(['--end-index', str(self.Parameters.end_index)])
        if self.Parameters.columns:
            binary_cmd.extend(['--columns'] + self.Parameters.columns)
        if self.Parameters.schema:
            binary_cmd.extend(['--schema', self.Parameters.schema])
        if self.Parameters.update:
            binary_cmd.append('--update')
        if self.Parameters.cast:
            binary_cmd.extend(['--cast', self.Parameters.cast])
        binary_cmd.extend(['--sync-clusters'] + self.Parameters.sync_clusters)
        binary_cmd.extend(['--async-clusters'] + self.Parameters.async_clusters)

        self.run_command(binary_cmd)
