import logging

import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters

from sandbox.projects.common import apihelpers
from sandbox.projects.modadvert import resource_types


class ModadvertEvilMisprintsStatistics(sdk_task.SandboxTask):
    type = "MODADVERT_EVIL_MISPRINTS_STATISTICS"
    client_tags = ctc.Tag.LINUX_PRECISE

    class YtProxyUrl(sdk_parameters.SandboxStringParameter):
        name = "yt_proxy_url"
        description = name
        default_value = "hahn.yt.yandex.net"

    class VaultUser(sdk_parameters.SandboxStringParameter):
        name = "vault_user"
        description = name
        default_value = "MODADVERT"

    class YtTokenVaultName(sdk_parameters.SandboxStringParameter):
        name = "yt_token_vault_name"
        description = name
        default_value = "yt-token"

    class SourceTable(sdk_parameters.SandboxStringParameter):
        name = "source_table"
        description = name
        default_value = "//home/direct-moderate/prod-banners"

    class OutputTable(sdk_parameters.SandboxStringParameter):
        name = "output_table"
        description = name
        default_value = "//home/modadvert/Misprints/Words"

    class MinRelSize(sdk_parameters.SandboxFloatParameter):
        name = "min_rel_size"
        description = "Minimum relative size"
        default_value = 1.0

    class MinRelCommonSize(sdk_parameters.SandboxFloatParameter):
        name = "min_rel_common_size"
        description = "Minimum relative common size"
        default_value = 0.95

    class MaxInvalidCommonRowCount(sdk_parameters.SandboxIntegerParameter):
        name = "max_invalid_common_row_count"
        description = "Maximum invalid common row count"
        default_value = 0

    input_parameters = [
        YtProxyUrl,
        VaultUser,
        YtTokenVaultName,
        SourceTable,
        OutputTable,
        MinRelSize,
        MinRelCommonSize,
        MaxInvalidCommonRowCount,
    ]

    def on_execute(self):
        logging.info("starting ModadvertEvilMisprintsStatistics on_execute()...")
        from projects.modadvert.common.utils import run_command_with_livelog

        resource = apihelpers.get_last_resource_with_attribute(
            resource_types.YA_PACKAGE,
            "resource_name",
            "modadvert-evil-misprints-stat"
        )
        tarball_path = self.sync_resource(resource)

        unpack_binary_cmd = ['tar', '-xvf', tarball_path]
        evil_misprints_stat = [
            "./evil_misprints_stat",
            "--yt-proxy-url", str(self.ctx.get(self.YtProxyUrl.name)),
            "--source-table", str(self.ctx.get(self.SourceTable.name)),
            "--output-table", str(self.ctx.get(self.OutputTable.name)),
            '--min-rel-size', str(self.ctx.get(self.MinRelSize.name)),
            '--min-rel-common-size', str(self.ctx.get(self.MinRelCommonSize.name)),
            '--max-invalid-common-row-count', str(self.ctx.get(self.MaxInvalidCommonRowCount.name)),
        ]

        run_command_with_livelog(unpack_binary_cmd)
        run_command_with_livelog(
            evil_misprints_stat,
            env={
                'YT_TOKEN': self.get_vault_data(self.ctx.get(self.VaultUser.name), self.ctx.get(self.YtTokenVaultName.name)),
            }
        )

        logging.info("finished ModadvertEvilMisprintsStatistics on_execute()...")


__Task__ = ModadvertEvilMisprintsStatistics
