from sandbox import sdk2
import sandbox.common.types.client as ctc

from sandbox.projects.modadvert.common import modadvert


class ModadvertFilterWidePhrases(modadvert.ModadvertBaseRunBinaryTask):
    """
    MODADVERT-274: Sends for remoderation banners with wide phrases (often used by spammers)
    """

    resource_name = 'modadvert-offline-wide-phrases-filter-binary'

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseRunBinaryTask.Parameters):
        cluster = sdk2.parameters.String('YT cluster', default='arnold')
        debug_table = sdk2.parameters.String('Debug table', default='//home/modadvert/test/iakolzin/WidePhrasesDebug')
        max_phrase_width = sdk2.parameters.Float('Max phrase width', default=1.2)
        min_word_density = sdk2.parameters.Float('Min word density', default=0.55)
        check_url = sdk2.parameters.String('Check URL', default='http://9048.ppcmoddev2.yandex-team.ru/jsonrpc/')
        remoderate_url = sdk2.parameters.String('Remoderate URL', default='http://9049.ppcmoddev2.yandex-team.ru/jsonrpc/')
        high_priority_clients_table = sdk2.parameters.String('High priority clients table', default='//home/modadvert/ClientPrioritiesHigh')
        medium_priority_clients_table = sdk2.parameters.String('Medium priority clients table', default='//home/modadvert/ClientPrioritiesMedium')
        client_white_list_table = sdk2.parameters.String('Client white list table', default='//home/modadvert/ClientWhiteListDynamic')
        prod_phrases_table = sdk2.parameters.String('prod-phrases table', default='//home/direct-moderate/prod-phrases')
        prod_banners_table = sdk2.parameters.String('prod-banners table', default='//home/direct-moderate/prod-banners')

    def create_command(self):
        command = [
            './offline_wide_phrases_filter',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--debug-table', self.Parameters.debug_table,
            '--max-phrase-width', str(self.Parameters.max_phrase_width),
            '--min-word-density', str(self.Parameters.min_word_density),
            '--ask-url', self.Parameters.check_url,
            '--remoderate-url', self.Parameters.remoderate_url,
            '--high-priority-clients-table', self.Parameters.high_priority_clients_table,
            '--medium-priority-clients-table', self.Parameters.medium_priority_clients_table,
            '--client-whitelist-table', self.Parameters.client_white_list_table,
            '--phrases-table', self.Parameters.prod_phrases_table,
            '--banners-table', self.Parameters.prod_banners_table,
        ]
        return command
