# -*- coding: utf-8 -*-
import logging

import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters

from sandbox.common.types.client import Tag
from sandbox.sandboxsdk.channel import channel
from sandbox.projects.modadvert import resource_types


class BinariesResource(sdk_parameters.LastReleasedResource):
    required = True
    name = 'binaries_resource'
    description = 'Resource with binaries'
    resource_type = resource_types.YA_PACKAGE


class Cluster(sdk_parameters.SandboxStringParameter):
    name = "cluster"
    description = name
    default_value = "hahn"


class VaultUser(sdk_parameters.SandboxStringParameter):
    name = "vault_user"
    description = name
    default_value = "MODADVERT"


class YtTokenVaultName(sdk_parameters.SandboxStringParameter):
    name = "yt_token_vault_name"
    description = name
    default_value = "yt-token"


class LyncherTables(sdk_parameters.SandboxStringParameter):
    name = "lyncher_tables"
    description = name
    default_value = ""


class ProdTable(sdk_parameters.SandboxStringParameter):
    name = "prod_table"
    description = name
    default_value = "//home/direct-moderate/prod-banners"


class LookupOffsetDays(sdk_parameters.SandboxIntegerParameter):
    name = "lookup_offset_days"
    description = name
    default_value = 30


class DstTable(sdk_parameters.SandboxStringParameter):
    name = "dst_table"
    description = name
    default_value = ""


class MinRelSize(sdk_parameters.SandboxFloatParameter):
    name = "min_rel_size"
    description = "Minimum relative size"
    default_value = 1.0


class MinRelCommonSize(sdk_parameters.SandboxFloatParameter):
    name = "min_rel_common_size"
    description = "Minimum relative common size"
    default_value = 0.95


class ModAdvertGetBannerManualResults(sdk_task.SandboxTask):
    type = "MODADVERT_GET_BANNER_MANUAL_RESULTS"

    # TODO: Remove me when ACL in direct-mod is fixed
    client_tags = Tag.LINUX_PRECISE & Tag.GENERIC & ~Tag.LXC

    input_parameters = [
        BinariesResource,
        Cluster,
        VaultUser,
        YtTokenVaultName,
        LyncherTables,
        ProdTable,
        LookupOffsetDays,
        DstTable,
        MinRelSize,
        MinRelCommonSize,
    ]

    def on_execute(self):
        logging.info('starting ModAdvertGetBannerManualResults on_execute()...')
        from projects.modadvert.common.utils import run_command_with_livelog

        binaries_tarball_path = channel.task.sync_resource(self.ctx[BinariesResource.name])
        run_command_with_livelog(['tar', '-xvf', binaries_tarball_path])

        run_command_with_livelog(
            [
                './get_banner_manual_results',
                '--cluster', self.ctx[Cluster.name],
                '--lyncher-tables', self.ctx[LyncherTables.name],
                '--prod-table', self.ctx[ProdTable.name],
                '--lookup-offset-days', str(self.ctx[LookupOffsetDays.name]),
                '--dst-table', self.ctx[DstTable.name],
                '--min-rel-size', str(self.ctx.get(MinRelSize.name)),
                '--min-rel-common-size', str(self.ctx.get(MinRelCommonSize.name)),
            ],
            env={
                'YT_TOKEN': self.get_vault_data(self.ctx.get(VaultUser.name), self.ctx.get(YtTokenVaultName.name)),
            }
        )

        logging.info('finished ModAdvertGetBannerManualResults on_execute()')


__Task__ = ModAdvertGetBannerManualResults
