# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.modadvert import resource_types
from sandbox.projects.modadvert.common import modadvert


class ModadvertGetManuallyModeratedRejects(modadvert.ModadvertBaseYtTask):

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Get manually moderated rejects binaries resource',
                resource_type=resource_types.MODADVERT_GET_MANUALLY_MODERATED_REJECTS_BINARY,
                required=True
        )


        with modadvert.ModadvertBaseYtTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='arnold')
        executable = sdk2.parameters.Resource('Executable resource')
        banners_to_remoderate_table = sdk2.parameters.String('Source table', default='//home/modadvert/AbuseRemoderationJoined')
        dynamic_dst_table = sdk2.parameters.String('Destination table', default='//home/modadvert/popovskii/similar_banners')
        error_ids = sdk2.parameters.List('Error ids', default=['129'])

    def create_command(self):
        cmd = [
            './get_manually_moderated_rejects',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--banners-to-remoderate-table', self.Parameters.banners_to_remoderate_table,
            '--dynamic-dst-table', self.Parameters.dynamic_dst_table,
            '--error-ids',
        ]
        cmd.extend(self.Parameters.error_ids)
        return cmd

    def on_before_execute(self):
        super(ModadvertGetManuallyModeratedRejects, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        self.run_command(self.create_command(), log_prefix='main')
