# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.modadvert.common import modadvert


class ModadvertGetMatrixnetClientKarma(modadvert.ModadvertBaseYtTask):
    """Runs ./get_mx_client_karma"""

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        mx_model_client_karma = sdk2.parameters.String('mx_model_client_karma', default='modadvert_mx_model_client_karma')
        src_table = sdk2.parameters.String('src_table', default='//home/modadvert/ClientFactorsTotal')
        dst_table = sdk2.parameters.String('dst_table', default='//home/modadvert/popovskii/client_karma')
        dynamic_dst_table = sdk2.parameters.String('dynamic_dst_table', default='')
        handler_of_factors = sdk2.parameters.String('handler_of_factors', default='v1')
        executable = sdk2.parameters.Resource('Executable resource')

        with modadvert.ModadvertBaseRunBinaryTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='arnold')

        modadvert.ModadvertBaseYtTask.Parameters.tokens.default['SANDBOX_TOKEN'] = 'sandbox-token'

    def create_command(self):
        return [
            sdk2.ResourceData(self.Parameters.executable).path.as_posix(),
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--mx-model-client-karma', self.Parameters.mx_model_client_karma,
            '--src-table', self.Parameters.src_table,
            '--dst-table', self.Parameters.dst_table,
            '--dynamic-dst-table', self.Parameters.dynamic_dst_table,
            '--handler-of-factors', self.Parameters.handler_of_factors,
        ]

    def on_execute(self):
        self.run_command(self.create_command(), log_prefix='main')
