# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertGrepImgRejects(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-560: Grep images rejects from ProdImages and find similars.
    ./grep_img_rejects
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with modadvert.ModadvertBaseYtTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='arnold')

        with sdk2.parameters.Group('Executable') as binary_group:
            executable = sdk2.parameters.Resource(
                'Resource with grep image rejects binary',
                resource_type=[resource_types.MODADVERT_GREP_IMG_REJECTS],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            verdicts_log_dir = sdk2.parameters.String('Verdicts log directory path', default='//logs/modadvert-supermoderation-add-verdicts-log/30min')
            cv_table = sdk2.parameters.String('CV index table path', default='//home/modadvert/CVIndex')
            cv_ignore = sdk2.parameters.String('CV ignore index table path', default='//home/modadvert/CVIgnore')
            cv_moderator_id = sdk2.parameters.Integer('Moderator ID for similars', required=True)
            error_ids = sdk2.parameters.List('Errors IDs to grep', default=['122', '123', '127'])
            batch_size = sdk2.parameters.Integer('Batch size', default=10000)
            offset = sdk2.parameters.Integer('Lookup time', default=1)
            offset_units = sdk2.parameters.String('Lookup time units', default='days')
            dynamic_dst_table = sdk2.parameters.String('Destination rejects table', default='//home/modadvert/ImgManualRejects')
            disable_cv = sdk2.parameters.Bool('Disable CV', default=False)

    def on_execute(self):
        binary_cmd = [
            sdk2.ResourceData(self.Parameters.executable).path.as_posix(),
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--verdicts-log-dir', self.Parameters.verdicts_log_dir,
            '--cv-table', self.Parameters.cv_table,
            '--cv-ignore', self.Parameters.cv_ignore,
            '--cv-moderator-id', self.Parameters.cv_moderator_id,
            '--batch-size', str(self.Parameters.batch_size),
            '--offset', str(self.Parameters.offset),
            '--offset-units', self.Parameters.offset_units,
            '--dynamic-dst-table', self.Parameters.dynamic_dst_table,
            '--error-ids',
        ]

        binary_cmd.extend(self.Parameters.error_ids)

        if self.Parameters.disable_cv:
            binary_cmd.append('--disable-cv')

        self.run_command(binary_cmd)
