# -*- coding: utf-8 -*-
import json

from sandbox import sdk2
from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertLicensesDynamicInserter(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-1926: Copy licenses into dynamic table.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with insert_dynamic binary',
                resource_type=[resource_types.MODADVERT_LICENSES_DYNAMIC_INSERTER],
                required=True
            )

        with modadvert.ModadvertBaseYtTask.Parameters.clusters_group() as clusters_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='hahn')

        with sdk2.parameters.Group('Source options') as source_options_group:
            src_table = sdk2.parameters.String(
                'Source table',
                default='//home/direct-moderate/licenses'
            )

        with sdk2.parameters.Group('Destination options') as destination_options_group:
            dst_table = sdk2.parameters.String(
                'Destination dynamic table',
                default='//home/modadvert/Licenses'
            )

        with sdk2.parameters.Group('Insertion details') as insertion_details_group:
            columns_rename = sdk2.parameters.Dict(
                'Rename this columns before insertion src->dst (optional)',
                default={},
                required=False,
            )
            columns = sdk2.parameters.List(
                'Columns to insert (optional)',
                default=[],
                required=False,
            )
            chunk_size = sdk2.parameters.Integer(
                'Chunk size',
                default=50000
            )
            key_fields = sdk2.parameters.List(
                'Key fields',
                default=['clientID', 'reverse_domain', 'id']
            )

    def on_before_execute(self):
        super(ModadvertLicensesDynamicInserter, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './licenses_dynamic_inserter',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--src-table', self.Parameters.src_table,
            '--dst-table', self.Parameters.dst_table,
            '--chunk-size', self.Parameters.chunk_size,
        ]
        binary_cmd.extend(['--key-fields'] + self.Parameters.key_fields)
        if self.Parameters.columns:
            binary_cmd.extend(['--columns'] + self.Parameters.columns)
        if self.Parameters.columns_rename:
            binary_cmd.extend(['--columns-rename', json.dumps(self.Parameters.columns_rename)])
        self.run_command(binary_cmd)
