# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertLogsChunkMerger(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-255: Chunk merger for QLOUD http logs
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with logs merger binary',
                resource_type=[resource_types.MODADVERT_LOGS_CHUNK_MERGER],
                required=True
            )
        with sdk2.parameters.Group('Options') as options_group:
            keep_days = sdk2.parameters.Integer('Number of days to keep logs', default=7)
            directories = sdk2.parameters.List('YT directories with logs')

    def on_before_execute(self):
        super(ModadvertLogsChunkMerger, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './logs_chunk_merger',
        ] + ['--directories'] + (self.Parameters.directories or [])
        self.run_command(binary_cmd)
