# -*- coding: utf-8 -*-
import sandbox.common.types.client as ctc
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertLyncherReportVerdicts(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-928: Report verdicts from lyncher results
    """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with lyncher verdicts reporter binary',
                resource_type=[resource_types.MODADVERT_LYNCHER_REPORT_VERDICT_BINARY],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            lyncher_results = sdk2.parameters.List('Lyncher results', default=['//home/modadvert/lyncher/Results'])
            state_path = sdk2.parameters.String('State path', default='//home/modadvert/lyncher/VerdictsReporterState')

            supermoderation_url = sdk2.parameters.String('Supermoderation url', default='http://modadvert.yandex-team.ru/api/')
            send_to_supermoderation = sdk2.parameters.Bool('Send verdicts to SM Api', default=False)

            old_sm_url = sdk2.parameters.String('Old SM url', default='http://intapi.direct-mod.yandex.ru:7080/oauth/supermod/')
            remoderate_url = sdk2.parameters.String('Remoderate url', default='http://intapi.direct-mod.yandex.ru:7080/oauth/jsonrpc/')

            logs_table = sdk2.parameters.String('Log for sent verdicts', default='//home/modadvert/lyncher/SendLog')
            put_off_table = sdk2.parameters.String('Log for failed verdicts', default='//home/modadvert/lyncher/FailedToSendVerdicts')
            send_failed_ones = sdk2.parameters.Bool('Repeat send failed ones at next run', default=False)

            threads_count = sdk2.parameters.Integer('Threads count', default=5)
            chunk_size = sdk2.parameters.Integer('Sending chunk size', default=500)
            intapi_timeout = sdk2.parameters.Integer('Intapi timeout', default=60)
            sanity_check_verdicts_count = sdk2.parameters.Integer('Sanity check verdicts count', default=int(25E6))

            sleep_seconds = sdk2.parameters.Integer('Sleep seconds', required=False, default=1)
            iterations = sdk2.parameters.Integer('Number of iterations', required=False, default=10)

            phrase_antikarma_threshold = sdk2.parameters.Integer('Phrase antikarma threshold', default=10000)
            sitelink_filter_threshold = sdk2.parameters.Integer('Sitelink filter threshold', default=10000)

            send_to_solomon = sdk2.parameters.Bool('Send sensors to Solomon', default=False)
            solomon_testing = sdk2.parameters.Bool('Enable Solomon test mode', default=False)
            solomon_cluster = sdk2.parameters.String('Solomon cluster', default='hahn')
            solomon_service = sdk2.parameters.String('Solomon service', default='lyncher')

            convert_reasons = sdk2.parameters.Bool('Convert reasons literals to error ids', default=False)
            reasons_config = sdk2.parameters.String('YAML config with reasons string to errors int mapping', default='./reasons-config.yaml')
            broken_reasons_table = sdk2.parameters.String('Table to put broken reasons', default='//home/modadvert/lyncher/BrokenReasons')

            src_tvm_id = sdk2.parameters.Integer('Our TVM_ID', required=False)
            logbroker_tvm_id = sdk2.parameters.Integer('Logbroker TVM_ID', required=False)
            logbroker_host = sdk2.parameters.String('Logbroker host', required=False)
            logbroker_port = sdk2.parameters.Integer('Logbroker port', required=False)
            logbroker_topic = sdk2.parameters.String('Logbroker topic', required=False)
            skip_manual = sdk2.parameters.Bool('Stop sending of PRE_MODERATE verdicts direct to M1', default=False)
            send_to_lb = sdk2.parameters.Bool('Start sending of PRE_MODERATE verdicts to logbroker topic', default=False)
            logging_level = modadvert.LoggingLevel('Logging level', default='INFO')

    def on_before_execute(self):
        super(modadvert.ModadvertBaseYtTask, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './lyncher_report_verdicts',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--state-path', self.Parameters.state_path,

            '--supermoderation-url', self.Parameters.supermoderation_url,

            '--old-sm-url', self.Parameters.old_sm_url,
            '--remoderate-url', self.Parameters.remoderate_url,

            '--logs-table', self.Parameters.logs_table,
            '--put-off-table', self.Parameters.put_off_table,

            '--threads-count', str(self.Parameters.threads_count),
            '--chunk-size', str(self.Parameters.chunk_size),
            '--intapi-timeout', str(self.Parameters.intapi_timeout),
            '--sanity-check-verdicts-count', str(self.Parameters.sanity_check_verdicts_count),

            '--iterations', str(self.Parameters.iterations),
            '--sleep-seconds', str(self.Parameters.sleep_seconds),

            '--phrase-antikarma-threshold', str(self.Parameters.phrase_antikarma_threshold),
            '--sitelink-filter-threshold', str(self.Parameters.sitelink_filter_threshold),

            '--solomon-cluster', self.Parameters.solomon_cluster,
            '--solomon-service', self.Parameters.solomon_service,

            '--logging-level', self.Parameters.logging_level,
        ]
        if self.Parameters.send_to_supermoderation:
            binary_cmd.append('--send-to-supermoderation')
        if self.Parameters.send_failed_ones:
            binary_cmd.append('--send-failed-ones')
        if self.Parameters.send_to_solomon:
            binary_cmd.append('--send-to-solomon')
        if self.Parameters.solomon_testing:
            binary_cmd.append('--solomon-testing')
        if self.Parameters.solomon_testing:
            binary_cmd.append('--solomon-testing')
        if self.Parameters.convert_reasons:
            binary_cmd.append('--convert-reasons')
            binary_cmd.extend([
                '--reasons-config', self.Parameters.reasons_config,
                '--broken-reasons-table', self.Parameters.broken_reasons_table,
            ])
        if self.Parameters.src_tvm_id:
            binary_cmd.extend(['--src-tvm-id', str(self.Parameters.src_tvm_id)])
        if self.Parameters.logbroker_tvm_id:
            binary_cmd.extend(['--logbroker-tvm-id', str(self.Parameters.logbroker_tvm_id)])
        if self.Parameters.logbroker_host:
            binary_cmd.extend(['--logbroker-host', self.Parameters.logbroker_host])
        if self.Parameters.logbroker_port:
            binary_cmd.extend(['--logbroker-port', str(self.Parameters.logbroker_port)])
        if self.Parameters.logbroker_topic:
            binary_cmd.extend(['--logbroker-topic', self.Parameters.logbroker_topic])
        if self.Parameters.skip_manual:
            binary_cmd.append('--skip-manual')
        if self.Parameters.send_to_lb:
            binary_cmd.append('--send-to-lb')
        binary_cmd.extend(['--lyncher-results'] + self.Parameters.lyncher_results)

        self.run_command(binary_cmd)
