# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.modadvert.common import modadvert


class ModadvertMetricSimilarityIndexCollector(modadvert.ModadvertBaseRunBinaryTask):
    """
    MODADVERT-8627: collect index samples for lyncher's MetricSimilarityFactorProvider
    """

    resource_name = 'modadvert-metric-similarity-index-collector'

    class Parameters(modadvert.ModadvertBaseRunBinaryTask.Parameters):

        with sdk2.parameters.Group('YT tables'):
            yt_src_dir = sdk2.parameters.String(
                'YT directory with src tables',
                default='//logs/modadvert-supermoderation-add-verdicts-log/30min'
            )
            yt_result_table = sdk2.parameters.String(
                'YT table where index rows will be appended',
                default='//home/modadvert/metric_similarity_tables/BannersIndex'
            )
            max_result_rows = sdk2.parameters.Integer(
                'Maximum number of results rows. In case of overflow table\'s head will be erased',
                default=2200000
            )

        with sdk2.parameters.Group('Index selection parameters'):
            manual_circuits = sdk2.parameters.List(
                'List of circuits with manually labeled verdicts',
                default=['admin_interface', 'yang.was_seen']
            )
            min_text_length = sdk2.parameters.Integer(
                'Minimum length of text to insert in index',
                default=10
            )

        with sdk2.parameters.Group('State parameters'):
            yt_state_path = sdk2.parameters.String(
                'YT node with state where all processed tables stored',
                default='//home/modadvert/states/lyncher/metric_similarity/index_src_tables'
            )
            max_tables_in_state = sdk2.parameters.Integer(
                'Maximum number of tables to keep in state',
                default=1000
            )

    def create_command(self):
        command = [
            './metric_similarity_index_collect',
            '--yt-cluster', self.Parameters.yt_proxy_url,
            '--yt-src-dir', self.Parameters.yt_src_dir,
            '--yt-result-table', self.Parameters.yt_result_table,
            '--max-result-rows', self.Parameters.max_result_rows,
            '--min-text-length', self.Parameters.min_text_length,
            '--yt-state-path', self.Parameters.yt_state_path,
            '--max-tables-in-state', self.Parameters.max_tables_in_state
        ]
        command.extend(['--manual-circuits'] + self.Parameters.manual_circuits)
        return command
