# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.client as ctc

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertModerationAdapter(modadvert.ModadvertBaseRunSupermoderation):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC

    class Parameters(modadvert.ModadvertBaseRunSupermoderation.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with moderation adapter binary',
                resource_type=[resource_types.MODADVERT_MODERATION_ADAPTER_BINARY],
                required=True
            )
