# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertMordaClustering(modadvert.ModadvertBaseYtTask):
    """
    DIRECTMOD-10065: Morda clustering task
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with morda clustering binary',
                resource_type=[resource_types.MODADVERT_MORDA_CLUSTERING_BINARY],
                required=True
            )

        with sdk2.parameters.Group('Options') as options_group:
            yt_worker_proxy_url = modadvert.YtCluster('YT worker cluster', default='hahn')
            working_dir = sdk2.parameters.String('Working directory', default='//home/modadvert/toloka/morda')
            cache_table = sdk2.parameters.String('Cache table', default='//home/modadvert/toloka/morda/TolokaCache')
            min_toloka_table_row_count = sdk2.parameters.Integer('Minimal row count for toloka tables', default=5000)
            max_toloka_table_row_count = sdk2.parameters.Integer('Maximal row count for toloka tables', default=50000)
            period_in_days = sdk2.parameters.Integer('Periods of showing banners (in days)', default=30)
            min_clicks = sdk2.parameters.Integer('Minimal number of clicks', default=1)
            min_shows = sdk2.parameters.Integer('Minimal number of shows', default=9999999)
            max_rows_to_process = sdk2.parameters.Integer('Maximal number of rows to process for single run', default=100000)

    def on_before_execute(self):
        super(modadvert.ModadvertBaseYtTask, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './morda_clustering',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--yt-worker-proxy-url', self.Parameters.yt_worker_proxy_url,
            '--working-dir', self.Parameters.working_dir,
            '--cache-table', self.Parameters.cache_table,
            '--min-toloka-table-row-count', self.Parameters.min_toloka_table_row_count,
            '--max-toloka-table-row-count', self.Parameters.max_toloka_table_row_count,
            '--period-in-days', self.Parameters.period_in_days,
            '--min-clicks', self.Parameters.min_clicks,
            '--min-shows', self.Parameters.min_shows,
            '--max-rows-to-process', self.Parameters.max_rows_to_process,
        ]

        self.run_command(binary_cmd)
