from sandbox import sdk2
from sandbox.projects.modadvert.common import modadvert


class ModadvertPriorityClients(modadvert.ModadvertBaseRunBinaryTask):
    resource_name = 'modadvert-priority-clients'

    class Parameters(modadvert.ModadvertBaseRunBinaryTask.Parameters):
        yql_token_vault_name = sdk2.parameters.String('YQL OAuth token vault name', default='yql-oauth-token')
        yt_proxy_url_master = modadvert.YtCluster('YT master cluster for dynamic table (Markov)')
        client_domain_stat_yt_dir = sdk2.parameters.String('YT dir with client domain stat daily tables')
        domain_stat_clients_yt_dir = sdk2.parameters.String('YT dir with domain stat priority clients result daily tables')
        priority_clients_dynamic_table = sdk2.parameters.String('Destination dynamic table with all priority clients')
        domain_stat_from_date = sdk2.parameters.String('Domain stat from date')
        domain_stat_to_date = sdk2.parameters.String('Domain stat to date')
        domain_cost_threshold = sdk2.parameters.Float('Domain cost threshold', default=10000)
        client_domain_cost_threshold = sdk2.parameters.Float('Client domain cost threshold', default=1000)
        manual_clients_dynamic_table = sdk2.parameters.String('Dynamic table with manual priority clients')
        high_clients_table = sdk2.parameters.String('YT table with high priority clients')
        medium_clients_table = sdk2.parameters.String('YT table with medium priority clients')
        direct_priority_clients_table = sdk2.parameters.String('YT table with direct priority clients')
        client_karma_yt_dir = sdk2.parameters.String('YT dir with client karma daily tables')
        client_karma_threshold = sdk2.parameters.Float('Karma threshold')
        client_karma_threshold_delta = sdk2.parameters.Float('Karma threshold delta', default=0.1)
        clients_keep_days = sdk2.parameters.Integer('Life time for priority', default=30)
        max_client = sdk2.parameters.Integer('Max deleted client per run', default=10000)

    def get_yql_token(self):
        return sdk2.Vault.data(self.Parameters.vault_user, self.Parameters.yql_token_vault_name)

    def create_env(self):
        return {
            'YT_TOKEN': self.get_yt_token(),
            'YQL_TOKEN': self.get_yql_token(),
        }

    def create_command(self):
        command = [
            './priority_clients',
            '--yt-cluster', self.Parameters.yt_proxy_url,
            '--yt-cluster-master', self.Parameters.yt_proxy_url_master,
            '--client-domain-stat-yt-dir', self.Parameters.client_domain_stat_yt_dir,
            '--domain-stat-clients-yt-dir', self.Parameters.domain_stat_clients_yt_dir,
            '--priority-clients-dynamic-table', self.Parameters.priority_clients_dynamic_table,
            '--domain-stat-from-date', self.Parameters.domain_stat_from_date,
            '--domain-stat-to-date', self.Parameters.domain_stat_to_date,
            '--domain-cost-threshold', str(self.Parameters.domain_cost_threshold),
            '--client-domain-cost-threshold', str(self.Parameters.client_domain_cost_threshold),
            '--manual-clients-dynamic-table', self.Parameters.manual_clients_dynamic_table,
            '--high-clients-table', self.Parameters.high_clients_table,
            '--medium-clients-table', self.Parameters.medium_clients_table,
            '--direct-priority-clients-table', self.Parameters.direct_priority_clients_table,
            '--client-karma-yt-dir', self.Parameters.client_karma_yt_dir,
            '--client-karma-threshold', str(self.Parameters.client_karma_threshold),
            '--client-karma-threshold-delta', str(self.Parameters.client_karma_threshold_delta),
            '--clients-keep-days', str(self.Parameters.clients_keep_days),
            '--max-client', str(self.Parameters.max_client),
        ]
        return command
