# -*- coding: utf-8 -*-
import logging
import os
import re

import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.input_params as rm_params
from sandbox import sandboxsdk
from sandbox.common.utils import get_resource_link, get_task_link
from sandbox.projects.BuildDockerImageV6_01 import BuildDockerImageV6_01
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.release_machine.components.configs.supermoderation import SupermoderationCfg
from sandbox.projects.modadvert.common.constants import STARTREK_CLIENT_ENVIROMENTS

RESOURCES_TAGS = {
    'MODADVERT_SM_API_BINARY': 'supermoderation_api',
    'MODADVERT_SM_ADMIN_BINARY': 'supermoderation_admin',
    'MODADVERT_DIRECT_PROXY_BINARY': 'direct_proxy',
    'MODADVERT_BRANDS_API_BINARY': 'brands_api',
    'MODADVERT_QLYNCHER_BINARIES': 'lyncher',
    'MODADVERT_CUPID_HTTP_ENVIRONMENT_IMAGE': 'cupid'
}


class ModAdvertPushDockerImage(BuildDockerImageV6_01, object):

    type = 'MODADVERT_PUSH_DOCKER_IMAGE'

    environment = STARTREK_CLIENT_ENVIROMENTS

    class ResourceTypeName(sandboxsdk.parameters.SandboxStringParameter):
        name = 'resource_type_name'
        description = 'Resource type name'
        group = 'Testenv'

    class ComponentName(rm_params.ComponentName):
        default_value = SupermoderationCfg.name

    class ReleaseNumber(sandboxsdk.parameters.SandboxStringParameter):
        required = False
        name = 'release_number'
        description = name
        default_value = ''

    class ReleaseTagNumber(sandboxsdk.parameters.SandboxStringParameter):
        required = False
        name = 'release_tag_number'
        description = name
        default_value = ''

    input_parameters = [
        ResourceTypeName,
        ComponentName,
        ReleaseNumber,
        ReleaseTagNumber
    ] + BuildDockerImageV6_01.input_parameters

    def on_save(self):
        match = re.search('stable-([\d]+)-([\d]+)', self.ctx[self.ArcadiaUrl.name])
        version = '0.{}.{}'.format(match.group(1), match.group(2))
        self.ctx[self.RegistryTags.name] = ['modadvert/{}:{}'.format(RESOURCES_TAGS[self.ctx[self.ResourceTypeName.name]], version)]
        self.ctx[self.ReleaseTagNumber.name] = match.group(2)

    def on_execute(self):
        self.on_save()
        super(ModAdvertPushDockerImage, self).on_execute()
        self.send_execution_info()

    def get_c_info(self):
        return rmc.COMPONENTS[self.ctx[self.ComponentName.name]]()

    def send_execution_info(self):
        message = (
            'Task (({} {})) finished. Image from resource **{}** (({} {})) pushed to **registry.yandex.net/{}**'
        ).format(
            get_task_link(self.id),
            self.id,
            self.ctx[self.ResourceTypeName.name],
            get_resource_link(self.ctx[self.PackagedResource.name]),
            self.ctx[self.PackagedResource.name],
            self.ctx[self.RegistryTags.name][0]
        )

        release_number = self.ctx[self.ReleaseNumber.name]
        if release_number:
            c_info = self.get_c_info()
            st_helper = STHelper(self.get_vault_data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
            st_helper.comment(
                release_number,
                message,
                c_info
            )
        else:
            logging.info(message)


__Task__ = ModAdvertPushDockerImage
