# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertReplicaSwitcher(modadvert.ModadvertBaseYtTask):
    """
    MODADVERT-1571: Switch YT replicas.
    """

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):
        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with switch_supermoderation_dc binary',
                resource_type=[resource_types.MODADVERT_REPLICA_SWITCHER],
                required=True
            )

        with sdk2.parameters.Group('Switch targets') as switch_pathes_group:
            recurse_dirs = sdk2.parameters.List(
                'Directories to switch recursively',
                default=['//home/modadvert']
            )
            additional_tables = sdk2.parameters.List(
                'Additional tables to switch',
                default=['//home/modadvert/IDMRoles']
            )
            sync_names_storages = sdk2.parameters.List(
                'Sync cluster name storages',
                default=[
                    '//home/modadvert/working_yt_proxy_url',
                    '//home/modadvert/supermoderation/working_yt_proxy_url',
                ]
            )

        with sdk2.parameters.Group('Options') as options_group:
            sync_cluster = modadvert.YtCluster(
                'Switch sync to',
                default='hahn'
            )
            max_replication_lag_seconds = sdk2.parameters.Integer(
                "Max replication lag in seconds allowed (dangerous! raise carefully)",
                default=60
            )
            ignore_nonexistent_replicas = sdk2.parameters.Bool(
                "Ignore tables without replicas at desired sync cluster",
                default=True
            )
            testing = sdk2.parameters.Bool(
                "Testing mode (no changes)",
                default=False
            )

    def on_before_execute(self):
        super(ModadvertReplicaSwitcher, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    @classmethod
    def join_list(cls, lst):
        return ','.join(line.strip() for line in (lst or []))

    def on_execute_inner(self):
        binary_cmd = [
            './switch_supermoderation_dc',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--sync-cluster', self.Parameters.sync_cluster,
            '--max-replication-lag-seconds', self.Parameters.max_replication_lag_seconds,
        ]
        if self.Parameters.recurse_dirs:
            binary_cmd.extend(['--recurse-dirs'] + self.Parameters.recurse_dirs)
        if self.Parameters.additional_tables:
            binary_cmd.extend(['--additional-tables'] + self.Parameters.additional_tables)
        if self.Parameters.sync_names_storages:
            binary_cmd.extend(['--sync-name-storages'] + self.Parameters.sync_names_storages)
        if self.Parameters.testing:
            binary_cmd.append('--testing')
        if self.Parameters.ignore_nonexistent_replicas:
            binary_cmd.append('--ignore-nonexistent-replicas')
        self.run_command(binary_cmd)
