# -*- coding: utf-8 -*-
import pytest
from sandbox.projects.modadvert.RunComparison.stat import get_stat_table, get_verdicts_stat


@pytest.fixture(scope='module')
def sorted_rows():
    return [
        {'type': 'a', 'count': 7, 'feature_verdict': 'NA', 'base_verdict': 'NA'},
        {'type': 'a', 'count': 3, 'feature_verdict': 'REJECT', 'base_verdict': 'NA'},
        {'type': 'a', 'count': 10, 'feature_verdict': 'NA', 'base_verdict': 'REJECT'},
        {'type': 'b', 'count': 10, 'feature_verdict': 'REJECT', 'base_verdict': 'NA'},
        {'type': 'b', 'count': 10, 'feature_verdict': 'REJECT', 'base_verdict': None},
    ]


def test_get_verdicts_stat(sorted_rows):
    assert get_verdicts_stat(sorted_rows[:3]) == {
        'NA': {
            'feature': 17,
            'base': 10,
            'add': 10,
            'remove': 3,
            'diff_perc': 0.7,
        },
        'REJECT': {
            'feature': 3,
            'base': 10,
            'add': 3,
            'remove': 10,
            'diff_perc': -0.7,
        },
        'total': {
            'count': 20,
            'diff': 13,
            'diff_perc': 0.65,
        }
    }


MESSAGE = u"""#|
|| type | ACCEPT | NA | MANUAL | REJECT | None | total ||
|| a |  | 17 !!(green)+10!! !!(red)-3!! (!!(gray)+70.00%!!) |  | 3 !!(green)+3!! !!(red)-10!! (!!(gray)-70.00%!!) |  | !!(gray)13!! / 20 (65.00%) ||
**|| b |  | 0 !!(green)+0!! !!(red)-10!! (!!(red)-100.00%!!) |  | 20 !!(green)+20!! !!(red)-0!! (!!(green)+inf%!!) | 0 !!(green)+0!! !!(red)-10!! (!!(red)-100.00%!!) | !!(gray)20!! / 20 (100.00%) ||**
|#"""


def test_get_stat_table(sorted_rows):
    assert get_stat_table(['type'], sorted_rows, highlight_tolerance=0.8) == MESSAGE
