# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.modadvert.common import modadvert
from sandbox.projects.modadvert import resource_types


class ModadvertRunLaaSMR(modadvert.ModadvertBaseYtTask):
    """
    Runs given binary file with LaaS MR-runner
    """

    name = 'MODADVERT_RUN_LAAS_MR'

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):

        kill_timeout = 24 * 60 * 60  # 24h

        with sdk2.parameters.Group('Binary') as binary_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with laas_mr_runner binary',
                resource_type=resource_types.MODADVERT_LAAS_MR_RUNNER_BINARY
            )

        with sdk2.parameters.Group('Table parameters') as source_group:
            src_tables = sdk2.parameters.List('Source YT tables', required=True)
            dst_table = sdk2.parameters.String('Destination YT table', required=True)

        with sdk2.parameters.Group('YT run parameters') as yt_group:
            memory_limit = sdk2.parameters.Integer('Limit of YT jobs memory', required=False)
            job_count = sdk2.parameters.Integer('Number of YT jobs to run', required=False)
            user_slots = sdk2.parameters.Integer('Limit of simultaneously running jobs', required=False)
            max_failed_job_count = sdk2.parameters.Integer('Limit of YT failed jobs', required=False)
            pool = sdk2.parameters.String('YT pool', required=False)
            mount_sandbox_in_tmpfs = sdk2.parameters.Bool('Mount sandbox in tmpfs', required=False)
            lock_attempts = sdk2.parameters.Integer('Number of lock attempts', required=False)

    def create_env(self):
        env = super(ModadvertRunLaaSMR, self).create_env()
        env['PYTHONHASHSEED'] = '0'
        return env

    def on_before_execute(self):
        super(ModadvertRunLaaSMR, self).on_before_execute()
        self.untar_resource(self.Parameters.binaries_resource)

    def on_execute_inner(self):
        binary_cmd = [
            './laas_mr_runner',
            '--yt-cluster', self.Parameters.yt_proxy_url,
            '--dst-table', self.Parameters.dst_table,
        ]
        binary_cmd.extend(['--src-tables'] + self.Parameters.src_tables)
        if self.Parameters.memory_limit:
            binary_cmd.extend(['--yt-memory-limit', self.Parameters.memory_limit])
        if self.Parameters.job_count:
            binary_cmd.extend(['--yt-job-count', self.Parameters.job_count])
        if self.Parameters.user_slots:
            binary_cmd.extend(['--yt-user-slots', self.Parameters.user_slots])
        if self.Parameters.max_failed_job_count:
            binary_cmd.extend(['--yt-max-failed-job-count', self.Parameters.max_failed_job_count])
        if self.Parameters.pool:
            binary_cmd.extend(['--yt-pool', self.Parameters.pool])
        if self.Parameters.mount_sandbox_in_tmpfs:
            binary_cmd.append('--yt-mount-sandbox-in-tmpfs')
        if self.Parameters.lock_attempts:
            binary_cmd.extend(['--yt-lock-attempts', self.Parameters.lock_attempts])

        self.run_command(binary_cmd, log_prefix='main', env=self.create_env())
