# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.projects.common.build.parameters
import sandbox.projects.common.build.YaPackage as YaPackage

from sandbox.common.types.misc import NotExists
from sandbox.projects.modadvert import resource_types
from sandbox.projects.common.apihelpers import get_task_resource_id
from sandbox.projects.modadvert.common import modadvert


class ModadvertRunLyncherSDK2(modadvert.ModadvertBaseYtTask):

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(modadvert.ModadvertBaseYtTask.Parameters):

        with sdk2.parameters.Group('Binaries') as binaries_group:
            binaries_resource = sdk2.parameters.Resource(
                'Resource with all lyncher binaries',
                resource_type=resource_types.MODADVERT_LYNCHER_BINARIES,
                required=True
            )

        with sdk2.parameters.Group('Config') as config_group:
            config_resource = sdk2.parameters.Resource(
                'Resource with all lyncher config',
                resource_type=resource_types.MODADVERT_LYNCHER_CONFIG,
                required=True
            )

        with sdk2.parameters.Group('Launch parameters') as launch_group:
            max_rows_count = sdk2.parameters.Integer('Maximum rows count to process per launch')
            src_tables_dir = sdk2.parameters.String(
                'Source tables directory',
                default='//home/modadvert/lyncher/input/',
                required=True
            )
            verdicts_table = sdk2.parameters.String('Verdicts table (append)', required=True)
            use_separated_state = sdk2.parameters.Bool('Separated state', default=False, required=True)
            state_path = sdk2.parameters.String('State path', required=True)
            max_tables_age = sdk2.parameters.Integer('Max tables age to process in hours', required=False, default=48)
            primary_read_cluster = modadvert.YtCluster('Primary read cluster', default='arnold')
            secondary_read_cluster = modadvert.YtCluster('Secondary read cluster', default='Hahn')
            use_synchrophazotron = sdk2.parameters.Bool('Use synchrophazotron', default=True, required=True)
            debug = sdk2.parameters.Bool('Debug mode', default=True, required=True)
            split_results = sdk2.parameters.Bool('Split lyncher results', default=False, required=True)
            logging_level = modadvert.LoggingLevel('Logging level', default='INFO')

    def create_command(self):
        lyncher_cmd = [
            './lyncher',
            '--yt-proxy-url', self.Parameters.yt_proxy_url,
            '--src-table-dir', self.Parameters.src_tables_dir,
            '--verdicts-log-table', self.Parameters.verdicts_table,
            '--state-path', self.Parameters.state_path,
            '--max-tables-age-hours', str(self.Parameters.max_tables_age),
            '--primary-read-cluster', self.Parameters.primary_read_cluster,
            '--secondary-read-cluster', self.Parameters.secondary_read_cluster,
            '--conf', './default_config.yaml',
            '--logging-level', self.Parameters.logging_level,
        ]

        if self.Parameters.debug and self.Parameters.debug is not NotExists:
            lyncher_cmd.append('--testing')

        if self.Parameters.max_rows_count and self.Parameters.max_rows_count is not NotExists:
            lyncher_cmd.extend(['--max-rows-count', str(self.Parameters.max_rows_count)])

        if self.Parameters.use_synchrophazotron and self.Parameters.use_synchrophazotron is not NotExists:
            lyncher_cmd.extend(['--synchrophazotron-command', str(self.path('synchrophazotron'))])

        if self.Parameters.use_separated_state and self.Parameters.use_separated_state is not NotExists:
            lyncher_cmd.append('--use-separated-state')

        if self.Parameters.split_results:
            lyncher_cmd.append('--split-results')

        return lyncher_cmd

    def on_execute_inner(self):
        self.untar_resource(self.Parameters.binaries_resource)
        self.untar_resource(self.Parameters.config_resource)
        self.run_command(self.create_command(), log_prefix='main', env=dict(self.create_env(), QLOUD_DISCOVERY_INSTANCE='sandbox'))
